/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.EventClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.CustomFieldDefaultValueFKChangedEvent;
import com.atlassian.jira.webtests.ztests.user.anonymize.CFChangeTestBase;
import com.atlassian.jira.webtests.ztests.user.anonymize.ForeignKeysClient;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REFERENCE_PLUGIN, Category.ACTIVE_OBJECTS, Category.PLUGINS})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestCFMultiUserPickerKeyChange
extends CFChangeTestBase {
    private ForeignKeysClient foreignKeysClient;

    @Before
    public void setUp() {
        this.foreignKeysClient = new ForeignKeysClient(this.environmentData);
        this.backdoor.darkFeatures().enableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
        this.createUserPickerAndGoToConfigurationPage("com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker");
        this.assertDefaultValueForUserPickerEmpty();
    }

    @After
    public void teardown() {
        this.backdoor.darkFeatures().disableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
    }

    @Test
    public void shouldUpdateCustomFieldValues() {
        this.setDefaultValueForUserPickerField("admin");
        String someUserIssueKey = this.createIssue();
        this.setDefaultValueForUserPickerField("fred", "admin");
        String fredIssueKey = this.createIssue();
        String fredAnotherIssueKey = this.createIssue();
        Assert.assertThat(this.getCustomUserPickerFieldValues(fredIssueKey), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"fred", "admin"}));
        Assert.assertThat(this.getCustomUserPickerFieldValues(fredAnotherIssueKey), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"fred", "admin"}));
        Assert.assertThat(this.getCustomUserPickerFieldValues(someUserIssueKey), (Matcher)Matchers.contains((Object[])new String[]{"admin"}));
        ParsedResponse result = this.foreignKeysClient.triggerUpdate("fred", "fooBar");
        Assert.assertEquals((long)200L, (long)result.statusCode);
        Assert.assertThat(this.getCustomUserPickerFieldValues(fredIssueKey), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"fooBar", "admin"}));
        Assert.assertThat(this.getCustomUserPickerFieldValues(fredIssueKey), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new String[]{"fred"})));
        Assert.assertThat(this.getCustomUserPickerFieldValues(fredAnotherIssueKey), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"fooBar", "admin"}));
        Assert.assertThat(this.getCustomUserPickerFieldValues(fredAnotherIssueKey), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new String[]{"fred"})));
        Assert.assertThat(this.getCustomUserPickerFieldValues(someUserIssueKey), (Matcher)Matchers.contains((Object[])new String[]{"admin"}));
    }

    @Test
    public void shouldUpdateCustomFieldsDefaultValues() {
        this.setDefaultValueForUserPickerField("fred");
        EventClient.EventPoller eventPoller = this.backdoor.events().createPoller();
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred", "fooBar");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertDefaultValueForUserPickerFieldEquals("fooBar");
        Assert.assertThat(eventPoller.events(), (Matcher)Matchers.hasItem((Object)CustomFieldDefaultValueFKChangedEvent.class.getName()));
    }

    private List<String> getCustomUserPickerFieldValues(String issueKey) {
        return Optional.ofNullable((List)this.backdoor.issues().getIssue((String)issueKey).fields.get("customfield_10000")).orElse(Collections.emptyList()).stream().map(field -> (String)field.get("key")).collect(Collectors.toList());
    }
}

