/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.backdoor.WorkflowsControlExt;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.matchers.RegexMatchers;
import com.atlassian.jira.testkit.beans.UserDTO;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.ANONYMIZE_USER})
@LoginAs(user="admin")
@Restore(value="MNSTR-2761-anonymize-workflow.xml")
public class TestUserAnonymizeUserKeyInWorkflows
extends BaseJiraFuncTest {
    private UserAnonymizeControl userAnonymizeControl;

    @Before
    public void setUpTest() {
        this.userAnonymizeControl = new UserAnonymizeControl(this.getEnvironmentData());
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=803000)
    public void testAnonymizeUserKeyInIssueFieldUpdatePostFunctionAndMetadata() {
        WorkflowsControlExt.Workflow classicDefaultWorkflowBefore = this.backdoor.workflow().getWorkflowDetailed("classic default workflow");
        WorkflowsControlExt.Workflow draftOfWorkflowWithDraftBefore = this.backdoor.workflow().getWorkflowDraftDetailed("workflow with draft");
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)classicDefaultWorkflowBefore.getDescriptorXml(), (CharSequence)"<arg name=\"field.value\">fred</arg>"), (Matcher)Matchers.equalTo((Object)4));
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)classicDefaultWorkflowBefore.getDescriptorXml(), (CharSequence)"<meta name=\"jira.update.author.key\">fred</meta>"), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)draftOfWorkflowWithDraftBefore.getDescriptorXml(), (CharSequence)"<arg name=\"field.value\">fred</arg>"), (Matcher)Matchers.equalTo((Object)2));
        UserAnonymizeControl.AnonymizePerformResult anonymizeResponse = this.userAnonymizeControl.anonymize("fred", false, null, null, "admin");
        Optional<UserDTO> addedUserAfterChange = this.getUserByKey("fred");
        Assert.assertFalse((boolean)addedUserAfterChange.isPresent());
        Optional<UserDTO> anonymizedUserOption = this.getUserByKey(anonymizeResponse.getUserKeyNew());
        Assert.assertTrue((boolean)anonymizedUserOption.isPresent());
        UserDTO anonymizedUser = anonymizedUserOption.get();
        Assert.assertThat((Object)anonymizedUser.getKey(), (Matcher)RegexMatchers.regexMatches((String)"^JIRAUSER[0-9]+$"));
        Assert.assertFalse((boolean)anonymizedUser.isActive());
        WorkflowsControlExt.Workflow classicDefaultWorkflowAfter = this.backdoor.workflow().getWorkflowDetailed("classic default workflow");
        Assert.assertThat((String)"description field value should remain unchanged", (Object)StringUtils.countMatches((CharSequence)classicDefaultWorkflowAfter.getDescriptorXml(), (CharSequence)"<arg name=\"field.value\">fred</arg>"), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((String)"assignee field value should change", (Object)StringUtils.countMatches((CharSequence)classicDefaultWorkflowAfter.getDescriptorXml(), (CharSequence)String.format("<arg name=\"field.value\">%s</arg>", anonymizedUser.getKey())), (Matcher)Matchers.equalTo((Object)3));
        WorkflowsControlExt.Workflow draftOfWorkflowWithDraftAfter = this.backdoor.workflow().getWorkflowDraftDetailed("workflow with draft");
        Assert.assertThat((String)"description field value should remain unchanged", (Object)StringUtils.countMatches((CharSequence)draftOfWorkflowWithDraftAfter.getDescriptorXml(), (CharSequence)"<arg name=\"field.value\">fred</arg>"), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)classicDefaultWorkflowAfter.getDescriptorXml(), (CharSequence)"<meta name=\"jira.update.author.key\">fred</meta>"), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)classicDefaultWorkflowAfter.getDescriptorXml(), (CharSequence)String.format("<meta name=\"jira.update.author.key\">%s</meta>", anonymizedUser.getKey())), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((String)"assignee field value should change", (Object)StringUtils.countMatches((CharSequence)draftOfWorkflowWithDraftAfter.getDescriptorXml(), (CharSequence)String.format("<arg name=\"field.value\">%s</arg>", anonymizedUser.getKey())), (Matcher)Matchers.equalTo((Object)1));
    }

    private Optional<UserDTO> getUserByKey(String key) {
        return this.backdoor.usersAndGroups().getAllUsers().stream().filter(user -> user.getKey().equals(key)).findFirst();
    }
}

