/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.user.DeleteUserPage;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.HashMap;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.PROJECTS})
@LoginAs(user="admin")
public class TestUserRenameOnComponent
extends BaseJiraFuncTest {
    private static final String LEAN_MEAN_ID = "10100";
    private static final String SMALL_RATTY_ID = "10000";
    private static final String BIG_WUSSY_ID = "10001";
    private static final String WIRY_SKITTISH_ID = "10002";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("user_rename_doggy_components.xml");
    }

    @Test
    public void testJqlFunctionsFindRenamedComponentLeads() {
        HashMap<String, String[]> componentParamMap = new HashMap<String, String[]>();
        componentParamMap.put("components", new String[]{WIRY_SKITTISH_ID});
        String wirySkittishIssueKey = this.navigation.issue().createIssue("Canine", "Task", "Run in circles on the spot", componentParamMap);
        this.renameUser("cat", "crazy");
        this.renameUser("bb", "cat");
        this.navigation.gotoResource("../../../rest/api/2/search?jql=component%20in%20componentsLeadByUser(\"cat\")");
        this.tester.assertTextPresent("\"total\":0");
        this.navigation.gotoResource("../../../rest/api/2/search?jql=component%20in%20componentsLeadByUser(\"crazy\")");
        this.tester.assertTextPresent("\"total\":1");
        this.tester.assertTextPresent(wirySkittishIssueKey);
    }

    @Test
    public void testRenamedComponentLeadAssignedWhenDefault() {
        this.navigation.issue().goToCreateIssueForm("Canine", null);
        HashMap<String, Object> componentParamMap = new HashMap<String, String[]>();
        componentParamMap.put("components", new String[]{SMALL_RATTY_ID});
        String smallRattyIssueKey = this.navigation.issue().createIssue("Canine", "Task", "Yip in an annoying fashion", componentParamMap);
        this.navigation.issue().gotoIssue(smallRattyIssueKey);
        this.textAssertions.assertTextPresent(this.locator.id("assignee-val"), "Bob Belcher");
        this.navigation.issue().goToCreateIssueForm("Canine", null);
        componentParamMap = new HashMap();
        componentParamMap.put("components", new String[]{WIRY_SKITTISH_ID});
        String wirySkittishIssueKey = this.navigation.issue().createIssue("Canine", "Task", "Run in circles on the spot", componentParamMap);
        this.navigation.issue().gotoIssue(wirySkittishIssueKey);
        this.textAssertions.assertTextPresent(this.locator.id("assignee-val"), "Crazy Cat");
        this.navigation.issue().goToCreateIssueForm("Canine", null);
        componentParamMap = new HashMap();
        componentParamMap.put("components", new String[]{LEAN_MEAN_ID});
        String leanMeanIssueKey = this.navigation.issue().createIssue("Canine", "Task", "Bite off the postie's arm", componentParamMap);
        this.navigation.issue().gotoIssue(leanMeanIssueKey);
        this.textAssertions.assertTextPresent(this.locator.id("assignee-val"), "Candy Chaos");
    }

    @Test
    public void testRenamedComponentLeadElicitsDeletionWarning() {
        String bettysComponent = "Big & Wussy";
        String bbsComponent = "Small & Ratty";
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("bb"));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage("bb")));
        this.textAssertions.assertTextPresent(deleteUserPage.getComponentLink(), "Small & Ratty");
        deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("betty"));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage("betty")));
        this.textAssertions.assertTextPresent(deleteUserPage.getComponentLink(), "Big & Wussy");
        this.renameUser("bb", "belchyman");
        this.renameUser("betty", "bb");
        deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("bb"));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage("bb")));
        this.textAssertions.assertTextPresent(deleteUserPage.getComponentLink(), "Big & Wussy");
        this.textAssertions.assertTextNotPresent(deleteUserPage.getComponentLink(), "Small & Ratty");
        deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("belchyman"));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage("belchyman")));
        this.textAssertions.assertTextPresent(deleteUserPage.getComponentLink(), "Small & Ratty");
        this.textAssertions.assertTextNotPresent(deleteUserPage.getComponentLink(), "Big & Wussy");
    }

    private void renameUser(String from, String to) {
        this.navigation.gotoPage(String.format("secure/admin/user/EditUser!default.jspa?editName=%s", from));
        this.tester.setFormElement("username", to);
        this.tester.submit("Update");
    }
}

