/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.PROJECTS})
public class TestUserRenameOnDashboards
extends BaseJiraFuncTest {
    private static final String CHANGE_OWNERSHIP_OF_DEVELOPERS_DASHBOARD_URL = "secure/admin/dashboards/ChangeSharedDashboardOwner!default.jspa?dashboardId=10014&returnUrl=ViewSharedDashboards.jspa";
    private static final String CHANGE_OWNERSHIP_OF_FREDS_DASHBOARD_URL = "secure/admin/dashboards/ChangeSharedDashboardOwner!default.jspa?dashboardId=10019&returnUrl=ViewSharedDashboards.jspa";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestSharedDashboards.xml");
    }

    @Test
    public void testDashboardsSharedWithRenamedUser() {
        this.renameUser("anotherdev", "someotherdev");
        this.backdoor.usersAndGroups().addUser("anotherdev");
        this.backdoor.projectRole().deleteGroup("HSP", "Users", "jira-users");
        this.backdoor.projectRole().deleteGroup("MKY", "Users", "jira-users");
        this.navigation.login("someotherdev", "anotherdev");
        this.navigation.dashboard().navigateToPopular();
        this.tester.assertElementPresent("pp_10016");
        this.tester.assertElementPresent("pp_10015");
        this.navigation.login("anotherdev");
        this.navigation.dashboard().navigateToPopular();
        this.tester.assertElementNotPresent("pp_10016");
        this.tester.assertElementNotPresent("pp_10015");
    }

    @Test
    public void testRenamedUserRetainsDashboardOwnership() {
        this.renameUser("developer", "code monkey");
        this.renameUser("fred", "developer");
        this.navigation.login("code monkey", "developer");
        this.navigation.dashboard().navigateToMy();
        this.tester.assertElementPresent("pp_10012");
        this.tester.assertElementPresent("pp_10016");
        this.navigation.dashboard().navigateToPopular();
        this.textAssertions.assertTextPresent(this.locator.css("#pp_10013 > .cell-type-user"), "Developer");
        this.textAssertions.assertTextPresent(this.locator.css("#pp_10019 > .cell-type-user"), "Fred Normal");
        this.navigation.dashboard().navigateToFavourites();
        this.textAssertions.assertTextPresent(this.locator.css("#pp_10014 > .cell-type-user"), "Developer");
        this.navigation.login("developer", "fred");
        this.navigation.dashboard().navigateToFavourites();
        this.textAssertions.assertTextPresent(this.locator.css("#pp_10019 > .cell-type-user"), "Fred Normal");
        this.navigation.login("admin");
        this.navigateToSearchWithUserSelectInitializedFor("code monkey");
        this.tester.setFormElement("searchOwnerUserName", "code monkey");
        this.tester.submit("Search");
        this.textAssertions.assertTextPresent(this.locator.css("#pp_10013 > .cell-type-user"), "Developer");
        this.textAssertions.assertTextPresent(this.locator.css("#pp_10014 > .cell-type-user"), "Developer");
        this.navigateToSearchWithUserSelectInitializedFor("developer");
        this.tester.setFormElement("searchOwnerUserName", "developer");
        this.tester.submit("Search");
        this.textAssertions.assertTextPresent(this.locator.css("#pp_10018 > .cell-type-user"), "Fred Normal");
        this.textAssertions.assertTextPresent(this.locator.css("#pp_10019 > .cell-type-user"), "Fred Normal");
        this.tester.submit("Search");
        this.tester.assertElementNotPresent("pp_10013");
    }

    @Test
    public void testOwnershipChangeToRenamedUser() {
        this.renameUser("developer", "code monkey");
        this.renameUser("fred", "developer");
        this.navigation.gotoPage(CHANGE_OWNERSHIP_OF_DEVELOPERS_DASHBOARD_URL);
        FormParameterUtil form = new FormParameterUtil(this.tester, "change-owner-form-10014", "ChangeOwner");
        form.addOptionToHtmlSelect("owner", new String[]{"developer", "developer"});
        form.setFormElement("owner", "developer");
        form.submitForm();
        this.navigation.gotoPage("secure/admin/dashboards/ViewSharedDashboards.jspa");
        this.textAssertions.assertTextPresent(this.locator.css("#pp_10014 > .cell-type-user"), "Fred Normal");
        this.navigation.gotoPage(CHANGE_OWNERSHIP_OF_FREDS_DASHBOARD_URL);
        form = new FormParameterUtil(this.tester, "change-owner-form-10019", "ChangeOwner");
        form.addOptionToHtmlSelect("owner", new String[]{"code monkey", "code monkey"});
        form.setFormElement("owner", "code monkey");
        form.submitForm();
        this.navigation.gotoPage("secure/admin/dashboards/ViewSharedDashboards.jspa");
        this.textAssertions.assertTextPresent(this.locator.css("#pp_10019 > .cell-type-user"), "Developer");
    }

    private void renameUser(String from, String to) {
        this.navigation.gotoPage(String.format("secure/admin/user/EditUser!default.jspa?editName=%s", from));
        this.tester.setFormElement("username", to);
        this.tester.submit("Update");
    }

    private void navigateToSearchWithUserSelectInitializedFor(String userName) {
        this.tester.gotoPage("secure/ConfigurePortalPages.jspa?view=search&searchOwnerUserName=" + userName);
    }
}

