/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.ISSUES})
@LoginAs(user="admin")
public class TestUserRenameOnIssueXmlView
extends BaseJiraFuncTest {
    private static final String CF_CC = "customfield_10200";
    private static final String CF_TESTER = "customfield_10300";
    private static final XPath XPATH_ISSUES = DocumentHelper.createXPath((String)"//item");
    private static final XPath XPATH_CC = DocumentHelper.createXPath((String)"customfields/customfield[@id='customfield_10200']");
    private static final XPath XPATH_TESTER = DocumentHelper.createXPath((String)"customfields/customfield[@id='customfield_10300']");
    private static final XPath XPATH_CF_VALUES = DocumentHelper.createXPath((String)"customfieldvalues/customfieldvalue");
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Before
    public void setUpTest() {
        this.administration.restoreData("user_rename.xml");
    }

    @Test
    public void testXmlViewWithRenamedUsers() throws IOException, DocumentException {
        Element issue = this.getXmlIssue("COW-1");
        this.assertXmlViewUserWithFullName(issue, "assignee", "betty", "Betty Boop");
        this.assertXmlViewUserWithFullName(issue, "reporter", "cat", "Crazy Cat");
        this.assertXmlViewUsernames(issue, XPATH_CC, "admin", "bb");
        this.assertXmlViewUsernames(issue, XPATH_TESTER, "cc");
        issue = this.getXmlIssue("COW-3");
        this.assertXmlViewUserWithFullName(issue, "assignee", "bb", "Bob Belcher");
        this.assertXmlViewUserWithFullName(issue, "reporter", "cc", "Candy Chaos");
        this.assertXmlViewUsernames(issue, XPATH_CC, "admin", "betty");
        this.assertXmlViewUsernames(issue, XPATH_TESTER, "cat");
        List<Element> issues = this.runXmlSearch();
        issue = issues.get(1);
        this.assertXmlViewUserWithFullName(issue, "assignee", "bb", "Bob Belcher");
        this.assertXmlViewUserWithFullName(issue, "reporter", "cc", "Candy Chaos");
        this.assertXmlViewUsernames(issue, XPATH_CC, "admin", "betty");
        this.assertXmlViewUsernames(issue, XPATH_TESTER, "cat");
        issue = issues.get(3);
        this.assertXmlViewUserWithFullName(issue, "assignee", "betty", "Betty Boop");
        this.assertXmlViewUserWithFullName(issue, "reporter", "cat", "Crazy Cat");
        this.assertXmlViewUsernames(issue, XPATH_CC, "admin", "bb");
        this.assertXmlViewUsernames(issue, XPATH_TESTER, "cc");
    }

    @Test
    public void testXmlViewBeforeAndAfterAnotherRename() throws IOException, DocumentException {
        this.assertXmlViewUsernames(this.getXmlIssue("COW-1"), XPATH_TESTER, "cc");
        this.navigation.issue().viewXml("COW-3");
        this.assertXmlViewUserWithFullName(this.getXmlIssue("COW-3"), "reporter", "cc", "Candy Chaos");
        this.navigation.gotoPage("secure/admin/user/EditUser!default.jspa?editName=cc");
        this.tester.setFormElement("username", "candy");
        this.tester.submit("Update");
        Assert.assertEquals((Object)"/secure/admin/user/ViewUser.jspa?name=candy", (Object)this.navigation.getCurrentPage());
        Assert.assertEquals((Object)"candy", (Object)this.locator.id("username").getText());
        this.assertXmlViewUsernames(this.getXmlIssue("COW-1"), XPATH_TESTER, "candy");
        this.assertXmlViewUserWithFullName(this.getXmlIssue("COW-3"), "reporter", "candy", "Candy Chaos");
    }

    private Element getXmlIssue(String issueKey) throws IOException, DocumentException {
        this.navigation.issue().viewXml(issueKey);
        return this.issue(this.document());
    }

    private List<Element> runXmlSearch() throws IOException, DocumentException {
        this.navigation.issueNavigator().runXmlSearch("", "assignee", "reporter", CF_CC, CF_TESTER);
        return this.issues(this.document());
    }

    private Document document() throws IOException, DocumentException {
        return new SAXReader().read(this.tester.getDialog().getResponse().getInputStream());
    }

    private List<Element> issues(Document doc) {
        return XPATH_ISSUES.selectNodes((Object)doc).stream().map(Element.class::cast).collect(Collectors.toList());
    }

    private Element issue(Document doc) {
        return (Element)XPATH_ISSUES.selectSingleNode((Object)doc);
    }

    private List<Element> elementsByName(Element parent, String name) {
        ArrayList<Element> kids = new ArrayList<Element>();
        List nodes = parent.content();
        for (Object obj : nodes) {
            Element child;
            if (!(obj instanceof Element) || !name.equals((child = (Element)obj).getName())) continue;
            kids.add(child);
        }
        return kids;
    }

    private Element elementByName(Element parent, String name) {
        List<Element> list = this.elementsByName(parent, name);
        return list.isEmpty() ? null : list.get(0);
    }

    private List<String> customFieldValues(Element customField) {
        List nodes = XPATH_CF_VALUES.selectNodes((Object)customField);
        ArrayList<String> values = new ArrayList<String>(nodes.size());
        for (Object obj : nodes) {
            Element valueElement = (Element)obj;
            values.add(valueElement.getText());
        }
        return values;
    }

    private void assertXmlViewUserWithFullName(Element issue, String fieldName, String username, String fullName) {
        Element userField = this.elementByName(issue, fieldName);
        Assert.assertEquals((Object)username, (Object)userField.attribute("username").getValue());
        Assert.assertEquals((Object)fullName, (Object)userField.getTextTrim());
    }

    private void assertXmlViewUsernames(Object context, XPath xpath, String ... usernames) {
        Element customField = (Element)xpath.selectSingleNode(context);
        Assert.assertEquals(Arrays.asList(usernames), this.customFieldValues(customField));
    }
}

