/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.user.EditUserPage;
import com.atlassian.jira.functest.framework.page.ViewIssuePage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.PERMISSIONS})
@LoginAs(user="admin")
public class TestUserRenameOnPermissions
extends BaseJiraFuncTest {
    private static final String BETTY_USERNAME = "betty";
    private static final String BETTY2_USERNAME = "betty2";
    private static final String BB_USERNAME = "bb";
    @Inject
    private Administration administration;

    @Test
    public void testSingleUserPermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        Assert.assertTrue((boolean)this.userCanEdit(BETTY_USERNAME));
        this.removeInitialEditIssuePermissionTypes();
        Assert.assertFalse((boolean)this.userCanEdit(BETTY_USERNAME));
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.EDIT_ISSUES, BETTY_USERNAME);
        Assert.assertTrue((boolean)this.userCanEdit(BETTY_USERNAME));
        Assert.assertFalse((boolean)this.userCanEdit(BB_USERNAME));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser(BETTY_USERNAME);
        editUserPage.setUsername(BETTY2_USERNAME);
        editUserPage.submitUpdate();
        Assert.assertTrue((boolean)this.userCanEdit(BETTY2_USERNAME));
        Assert.assertFalse((boolean)this.userCanEdit(BB_USERNAME));
        this.backdoor.permissionSchemes().removeUserPermission(0L, ProjectPermissions.EDIT_ISSUES, BETTY2_USERNAME);
        Assert.assertFalse((boolean)this.userCanEdit(BETTY2_USERNAME));
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.EDIT_ISSUES, BB_USERNAME);
        Assert.assertTrue((boolean)this.userCanEdit(BB_USERNAME));
        Assert.assertFalse((boolean)this.userCanEdit(BETTY2_USERNAME));
    }

    @Test
    public void testReporterPermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.removeInitialEditIssuePermissionTypes();
        Assert.assertFalse((boolean)this.userCanEditIssue("cat", "COW-1"));
        this.backdoor.permissionSchemes().addReporterPermission(0L, ProjectPermissions.EDIT_ISSUES);
        Assert.assertTrue((boolean)this.userCanEditIssue("cat", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        Assert.assertTrue((boolean)this.userCanEditIssue("cc", "COW-3"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cat", "COW-3"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cat");
        editUserPage.setUsername("cat2");
        editUserPage.submitUpdate();
        Assert.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-3"));
    }

    @Test
    public void testAssigneePermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.removeInitialEditIssuePermissionTypes();
        Assert.assertFalse((boolean)this.userCanEditIssue(BETTY_USERNAME, "COW-1"));
        this.backdoor.permissionSchemes().addCurrentAssigneePermission(0L, ProjectPermissions.EDIT_ISSUES);
        Assert.assertTrue((boolean)this.userCanEditIssue(BETTY_USERNAME, "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue(BB_USERNAME, "COW-1"));
        Assert.assertTrue((boolean)this.userCanEditIssue(BB_USERNAME, "COW-3"));
        Assert.assertFalse((boolean)this.userCanEditIssue(BETTY_USERNAME, "COW-3"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser(BETTY_USERNAME);
        editUserPage.setUsername(BETTY2_USERNAME);
        editUserPage.submitUpdate();
        Assert.assertTrue((boolean)this.userCanEditIssue(BETTY2_USERNAME, "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue(BB_USERNAME, "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue(BETTY2_USERNAME, "COW-3"));
    }

    @Test
    public void testGroupPermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.removeInitialEditIssuePermissionTypes();
        Assert.assertFalse((boolean)this.userCanEditIssue("cat", "COW-1"));
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_ISSUES, "jira-developers");
        Assert.assertTrue((boolean)this.userCanEditIssue("cat", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cat");
        editUserPage.setUsername("cat2");
        editUserPage.submitUpdate();
        Assert.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        this.administration.usersAndGroups().removeUserFromGroup("cat2", "jira-developers");
        this.administration.usersAndGroups().addUserToGroup("cc", "jira-developers");
        Assert.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-1"));
        Assert.assertTrue((boolean)this.userCanEditIssue("cc", "COW-1"));
    }

    @Test
    public void testProjectLeadPermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.removeInitialEditIssuePermissionTypes();
        this.administration.project().setProjectLead("Bovine", "cat");
        Assert.assertFalse((boolean)this.userCanEditIssue("cat", "COW-1"));
        this.backdoor.permissionSchemes().addProjectLeadPermission(0L, ProjectPermissions.EDIT_ISSUES);
        Assert.assertTrue((boolean)this.userCanEditIssue("cat", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cat");
        editUserPage.setUsername("cat2");
        editUserPage.submitUpdate();
        Assert.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        this.administration.project().setProjectLead("Bovine", "cc");
        Assert.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-1"));
        Assert.assertTrue((boolean)this.userCanEditIssue("cc", "COW-1"));
    }

    @Test
    public void testUserCFPermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.removeInitialEditIssuePermissionTypes();
        Assert.assertFalse((boolean)this.userCanEditIssue("cat", "COW-2"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        this.backdoor.permissionSchemes().addUserCustomFieldPermission(0L, ProjectPermissions.EDIT_ISSUES, "customfield_10300");
        Assert.assertTrue((boolean)this.userCanEditIssue("cat", "COW-2"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-2"));
        Assert.assertTrue((boolean)this.userCanEditIssue("cc", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cat", "COW-1"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cat");
        editUserPage.setUsername("cat2");
        editUserPage.submitUpdate();
        Assert.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-2"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-1"));
    }

    @Test
    public void testGroupCFPermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.removeInitialEditIssuePermissionTypes();
        Assert.assertFalse((boolean)this.userCanEditIssue("cat", "COW-5"));
        this.backdoor.permissionSchemes().addGroupCustomFieldPermission(Long.valueOf(0L), ProjectPermissions.EDIT_ISSUES, "customfield_10400");
        Assert.assertTrue((boolean)this.userCanEditIssue("cat", "COW-5"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-5"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cat");
        editUserPage.setUsername("cat2");
        editUserPage.submitUpdate();
        Assert.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-5"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-5"));
        this.administration.usersAndGroups().removeUserFromGroup("cat2", "jira-developers");
        this.administration.usersAndGroups().addUserToGroup("cc", "jira-developers");
        Assert.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-5"));
        Assert.assertTrue((boolean)this.userCanEditIssue("cc", "COW-5"));
    }

    @Test
    public void testProjectRolePermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        Assert.assertTrue((boolean)this.userCanEditIssue("cat", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cat");
        editUserPage.setUsername("cat2");
        editUserPage.submitUpdate();
        Assert.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        this.administration.usersAndGroups().removeUserFromGroup("cat2", "jira-developers");
        this.administration.usersAndGroups().addUserToGroup("cc", "jira-developers");
        Assert.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-1"));
        Assert.assertTrue((boolean)this.userCanEditIssue("cc", "COW-1"));
        this.backdoor.permissionSchemes().replaceProjectRolePermission(0L, ProjectPermissions.EDIT_ISSUES, 10002L);
        Assert.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        this.backdoor.permissionSchemes().replaceProjectRolePermission(0L, ProjectPermissions.EDIT_ISSUES, 10003L);
        Assert.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        editUserPage = this.administration.usersAndGroups().gotoEditUser("cat2");
        editUserPage.setUsername("cat");
        editUserPage.submitUpdate();
        Assert.assertTrue((boolean)this.userCanEditIssue("cat", "COW-1"));
        Assert.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        this.backdoor.permissionSchemes().replaceProjectRolePermission(0L, ProjectPermissions.EDIT_ISSUES, 10004L);
        Assert.assertFalse((boolean)this.userCanEditIssue("cat", "COW-1"));
        Assert.assertTrue((boolean)this.userCanEditIssue("cc", "COW-1"));
    }

    private void removeInitialEditIssuePermissionTypes() {
        this.backdoor.permissionSchemes().removeProjectRolePermission(0L, ProjectPermissions.EDIT_ISSUES, 10001L);
    }

    private boolean userCanEdit(String username) {
        return this.userCanEditIssue(username, "COW-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean userCanEditIssue(String username, String issueKey) {
        String password = username;
        if (username.equals(BETTY2_USERNAME)) {
            password = BETTY_USERNAME;
        }
        if (username.equals("cat2")) {
            password = "cat";
        }
        try {
            this.navigation.login(username, password);
            ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue(issueKey);
            boolean bl = viewIssuePage.containsEditButton();
            return bl;
        }
        finally {
            this.navigation.login("admin");
        }
    }
}

