/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.page.IssueSearchPage;
import com.atlassian.jira.functest.framework.page.ViewIssuePage;
import com.atlassian.jira.functest.framework.page.ViewProfilePage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.table.HtmlTable;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER})
@LoginAs(user="admin")
@Restore(value="user_rename.xml")
public class TestUserRenameOnProfiles
extends BaseJiraFuncTest {
    private static final int CFID_CC = 10200;
    private static final int CFID_TESTER = 10300;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Test
    public void testUserRenameOnProfiles() throws Exception {
        this.assertCurrentUserProfileNames("admin", "Adam Ant");
        this.assertSpecificUserProfileNames("cc", "Candy Chaos");
        this.assertSpecificUserProfileNames("cat", "Crazy Cat");
        try {
            this.safeLogin("betty", "betty");
            this.assertCurrentUserProfileNames("betty", "Betty Boop");
            this.assertSpecificUserProfileNames("bb", "Bob Belcher");
            this.safeLogin("bb", "bb");
            this.assertCurrentUserProfileNames("bb", "Bob Belcher");
            this.assertSpecificUserProfileNames("betty", "Betty Boop");
            this.assertSpecificUserProfileNames("admin", "Adam Ant");
            this.safeLogin("bb#asdf", "bb#asdf");
            this.navigation.userProfile().gotoCurrentUserProfile();
            this.assertViewProfileNames("bb#asdf", "BB Asdf");
            Assert.assertTrue((boolean)new ViewProfilePage(this.locator).getChangePasswordLink().endsWith("username=bb%23asdf"));
        }
        finally {
            this.safeLogin("admin", "admin");
        }
    }

    @Test
    public void testUserHoverLinks() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("COW-1");
        Assert.assertEquals((Object)"betty", (Object)viewIssuePage.getAssigneeUsername());
        Assert.assertEquals((Object)"cat", (Object)viewIssuePage.getReporterUsername());
        Assert.assertEquals(Arrays.asList("admin", "bb"), viewIssuePage.getCustomFieldRelUsernames(10200));
        Assert.assertEquals((Object)"cc", (Object)viewIssuePage.getCustomFieldRelUsername(10300));
        viewIssuePage = this.navigation.issue().viewIssue("COW-3");
        Assert.assertEquals((Object)"bb", (Object)viewIssuePage.getAssigneeUsername());
        Assert.assertEquals((Object)"cc", (Object)viewIssuePage.getReporterUsername());
        Assert.assertEquals(Arrays.asList("admin", "betty"), viewIssuePage.getCustomFieldRelUsernames(10200));
        Assert.assertEquals((Object)"cat", (Object)viewIssuePage.getCustomFieldRelUsername(10300));
        IssueSearchPage issueSearchPage = this.navigation.issueNavigator().runSearch("");
        HtmlTable searchResultsTable = issueSearchPage.getResultsTable();
        HtmlTable.Row row = searchResultsTable.getRow(2);
        this.assertTableUsername("bb", row, "Assignee");
        this.assertTableUsername("cc", row, "Reporter");
        this.assertTableUsername("cat", row, "Tester");
        this.assertTableUsernames(Arrays.asList("admin", "betty"), row, "CC");
        row = searchResultsTable.getRow(4);
        this.assertTableUsername("betty", row, "Assignee");
        this.assertTableUsername("cat", row, "Reporter");
        this.assertTableUsername("cc", row, "Tester");
        this.assertTableUsernames(Arrays.asList("admin", "bb"), row, "CC");
        this.administration.usersAndGroups().gotoUserBrowser();
        this.tester.clickLinkWithText("BB Asdf");
        this.tester.assertLinkPresentWithText("bb_asdf@example.com");
    }

    @Test
    public void testRenameUser() throws Exception {
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("COW-1");
        Assert.assertEquals((Object)"cat", (Object)viewIssuePage.getReporterUsername());
        Assert.assertEquals((Object)"cc", (Object)viewIssuePage.getCustomFieldRelUsername(10300));
        this.navigation.gotoPage("secure/admin/user/EditUser!default.jspa?editName=cc");
        this.tester.setFormElement("username", "candy");
        this.tester.submit("Update");
        Assert.assertEquals((Object)"/secure/admin/user/ViewUser.jspa?name=candy", (Object)this.navigation.getCurrentPage());
        Assert.assertEquals((Object)"candy", (Object)this.locator.id("username").getText());
        viewIssuePage = this.navigation.issue().viewIssue("COW-1");
        Assert.assertEquals((Object)"cat", (Object)viewIssuePage.getReporterUsername());
        Assert.assertEquals((Object)"candy", (Object)viewIssuePage.getCustomFieldRelUsername(10300));
        this.navigation.userProfile().gotoUserProfile("candy");
        this.assertViewProfileNames("candy", "Candy Chaos");
        this.assertUserHoverDetailsForMissingUser("cc");
        this.assertUserHoverDetails("candy", "Candy Chaos", "candy@example.com");
    }

    private void safeLogin(String username, String password) {
        try {
            this.navigation.logout();
        }
        finally {
            this.navigation.login(username, password);
        }
    }

    private void gotoUserHover(String username) {
        this.navigation.gotoPage("/secure/ViewUserHover!default.jspa?decorator=none&username=" + username);
    }

    private void assertUserHoverDetailsForMissingUser(String username) {
        this.gotoUserHover(username);
        Assert.assertFalse((boolean)this.locator.id("avatar-full-name-link").exists());
        Assert.assertEquals((Object)("User does not exist: " + username), (Object)this.locator.css("div.user-hover-details").getText());
        Assert.assertEquals((Object)"", (Object)this.locator.id("user-hover-email").getText());
    }

    private void assertUserHoverDetails(String username, String fullName, String emailAddress) {
        this.gotoUserHover(username);
        Element link = (Element)this.locator.id("avatar-full-name-link").getNode();
        Assert.assertEquals((Object)username, (Object)link.getAttribute("title"));
        Assert.assertEquals((Object)fullName, (Object)link.getTextContent().trim());
        Assert.assertEquals((Object)emailAddress, (Object)this.locator.id("user-hover-email").getText());
    }

    private void assertCurrentUserProfileNames(String username, String fullname) {
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.assertViewProfileNames(username, fullname);
        Assert.assertTrue((boolean)new ViewProfilePage(this.locator).getChangePasswordLink().endsWith("username=" + username));
    }

    private void assertSpecificUserProfileNames(String username, String fullname) {
        this.navigation.userProfile().gotoUserProfile(username);
        this.assertViewProfileNames(username, fullname);
    }

    private void assertViewProfileNames(String username, String fullName) {
        ViewProfilePage viewProfilePage = new ViewProfilePage(this.locator);
        Assert.assertEquals((Object)username, (Object)viewProfilePage.getUsername());
        Assert.assertEquals((Object)fullName, (Object)viewProfilePage.getFullName());
    }

    private void assertTableUsername(String username, HtmlTable.Row row, String heading) {
        Node cellNode = row.getCellNodeForHeading(heading);
        Assert.assertEquals((Object)username, (Object)ViewIssuePage.getRelUsername(cellNode));
    }

    private void assertTableUsernames(List<String> usernames, HtmlTable.Row row, String heading) {
        Node cellNode = row.getCellNodeForHeading(heading);
        Assert.assertEquals(usernames, ViewIssuePage.getRelUsernames(cellNode));
    }
}

