/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.ProgressBar;
import com.atlassian.jira.functest.framework.WorkflowSchemes;
import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.WorkflowSchemesControl;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.google.common.collect.Iterables;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestCustomWorkflow
extends BaseJiraFuncTest {
    @Inject
    private ProgressBar progressBar;
    private WorkflowSchemes workflowSchemes;
    private WorkflowSchemesControl workflowSchemesControl;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUp() {
        this.workflowSchemes = new WorkflowSchemes(this.tester, this.assertions, this.backdoor, this.progressBar, this.navigation);
        this.workflowSchemesControl = new WorkflowSchemesControl((JIRAEnvironmentData)this.environmentData);
        this.backdoor.userProfile().changeUserTimezone("admin", TimeZone.getDefault().getID());
    }

    @Test
    public void testConditionsUseUnmodifiedIssue() {
        this.administration.restoreData("TestCustomWorkflow.xml");
        this.administration.workflows().goTo().copyWorkflow("jira_old", "Copied Workflow", "Workflow copied from JIRA default");
        Assert.assertTrue((boolean)this.administration.workflows().goTo().inactive().contains("Copied Workflow"));
        ViewWorkflows.WorkflowItem copiedWorkflowItem = (ViewWorkflows.WorkflowItem)this.administration.workflows().goTo().inactive().get(0);
        Assert.assertTrue((boolean)copiedWorkflowItem.lastModified().contains(new SimpleDateFormat("dd/MMM/yy").format(new Date())));
        Assert.assertTrue((boolean)copiedWorkflowItem.lastModified().contains("Administrator"));
        this.editTransitionScreen("Copied Workflow", "Start Progress", "Workflow Screen");
        this.addWorkflowPostfunction("Copied Workflow", "In Progress", "Stop Progress", "com.atlassian.jira.plugin.system.workflow:assigntolead-function");
        this.enableWorkflow();
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue");
        try {
            this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
            this.navigation.issue().viewIssue(key);
            this.workflowUtil.clickAction("action_id_4");
            this.tester.selectOption("assignee", "Bob The Builder");
        }
        finally {
            this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        }
        this.tester.submit();
        Assert.assertNotNull((Object)this.tester.getDialog().getResponse().getURL());
        Assert.assertTrue((boolean)this.tester.getDialog().getResponse().getURL().getPath().endsWith("browse/" + key));
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "opsbar-transitions_more"), "In Progress");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "assignee-val"), "Bob The Builder");
        this.navigation.logout();
        this.navigation.login("bob", "bob");
        this.navigation.issue().gotoIssue(key);
        this.workflowUtil.clickAction("action_id_301");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "opsbar-transitions_more"), "Open");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "assignee-val"), "Administrator");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
    }

    @Test
    public void testLastModifiedWithFunnyCharacters() {
        this.administration.restoreData("blankWithOldDefault.xml");
        this.administration.usersAndGroups().addUser("\"meta\"user", "meta", "\"meta\" user lastname", "meta@example.com");
        this.administration.usersAndGroups().addUserToGroup("\"meta\"user", "jira-administrators");
        this.navigation.logout();
        this.navigation.login("\"meta\"user", "meta");
        this.administration.workflows().goTo().copyWorkflow("jira", "Copied Workflow", "Workflow copied from JIRA default");
        Assert.assertTrue((boolean)this.administration.workflows().goTo().inactive().contains("Copied Workflow"));
        ViewWorkflows.WorkflowItem copiedWorkflowItem = (ViewWorkflows.WorkflowItem)Iterables.getOnlyElement((Iterable)((Object)this.administration.workflows().goTo().inactive()));
        Assert.assertTrue((boolean)copiedWorkflowItem.lastModified().contains(new SimpleDateFormat("dd/MMM/yy").format(new Date())));
        Assert.assertTrue((boolean)copiedWorkflowItem.lastModified().contains("\"meta\" user lastname"));
    }

    private void enableWorkflow() {
        this.workflowSchemes.addWorkFlowScheme("New Workflow Scheme", "Test workflow scheme.");
        this.workflowSchemesControl.assignScheme(10000L, "Bug", "Copied Workflow");
        this.administration.project().associateWorkflowScheme("homosapien", "New Workflow Scheme", null, true);
        this.workflowSchemes.waitForSuccessfulWorkflowSchemeMigration("homosapien", "New Workflow Scheme");
    }

    public void editTransitionScreen(String workflow_name, String transition_name, String transitionFieldScreen) {
        this.administration.workflows().goTo().workflowSteps(workflow_name);
        this.tester.clickLinkWithText(transition_name);
        this.tester.clickLink("edit_transition");
        this.tester.setFormElement("transitionName", transition_name);
        if (transitionFieldScreen != null) {
            this.tester.selectOption("view", transitionFieldScreen);
        }
        this.tester.submit();
    }

    private void selectMultiOptionByValue(String selectName, String value) {
        this.tester.checkCheckbox(selectName, value);
    }

    private void addWorkflowPostfunction(String workflowName, String stepName, String transitionName, String postFunctionName) {
        this.administration.workflows().goTo().workflowSteps(workflowName);
        this.tester.clickLinkWithText(transitionName);
        this.tester.clickLinkWithText("Post Functions");
        this.tester.clickLinkWithText("Add post function", 0);
        this.selectMultiOptionByValue("type", postFunctionName);
        this.tester.submit();
    }
}

