/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.webtests.ztests.workflow.AbstractTestDraftWorkflowSchemeMigration;
import com.atlassian.jira.webtests.ztests.workflow.AbstractTestWorkflowSchemeMigration;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
public class TestDraftWorkflowSchemeMultipleProjectsMigration
extends AbstractTestDraftWorkflowSchemeMigration {
    @Inject
    private Administration administration;

    @Test
    @Restore(value="WorkflowSchemePublishingMultipleMigrationTest.xml")
    public void testMigrateMultipleProjects() {
        this.publishDraft();
        this.assertStandardIssues("TST");
        this.assertStandardIssues("TSTII");
        this.assertSchemeAndNoDraft("Test Project");
        this.assertSchemeAndNoDraft("Test Project II");
        this.assertNoScheme("Copy of Source Workflow Scheme");
        this.assertSchemeIdChanged("Source Workflow Scheme", 10000L);
    }

    @Test
    @Restore(value="WorkflowMigrationTestBrokenHalfWayMultiple.xml")
    public void testWorkflowMigrationHalfMigratedDataInTheFirstProject() {
        this.publishDraft();
        this.assertIssuesMigratedAndChangeHistory("TST");
        this.assertStandardIssues("TSTII");
        this.assertSchemeAndNoDraft("Test Project");
        this.assertSchemeAndNoDraft("Test Project II");
        this.assertInactiveSchemeExists("Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)");
        this.assertNoScheme("Copy 2 of Source Workflow Scheme");
        this.assertSchemeIdChanged("Source Workflow Scheme", 10000L);
    }

    @Test
    @Restore(value="WorkflowMigrationTestIssueWithUnupdatedIssueMultiple.xml")
    public void testWorkflowMigrationWithUnupdatedIssueInTheFirstProject() {
        this.publishDraft();
        this.assertIssuesMigratedAndChangeHistory("TST");
        this.assertStandardIssues("TSTII");
        this.assertSchemeAndNoDraft("Test Project");
        this.assertSchemeAndNoDraft("Test Project II");
        this.assertInactiveSchemeExists("Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)");
        this.assertNoScheme("Copy 2 of Source Workflow Scheme");
        this.assertSchemeIdChanged("Source Workflow Scheme", 10000L);
    }

    @Test
    @Restore(value="WorkflowMigrationTestUnchangedSchemeMultiple.xml")
    public void testWorkflowMigrationWithUnupdatedWorkflowSchemeInTheFirstProject() {
        this.publishDraft();
        this.assertIssuesAfterMigrationWithUnupdatedWorkflowScheme();
        this.assertStandardIssues("TSTII");
        this.assertSchemeAndNoDraft("Test Project");
        this.assertSchemeAndNoDraft("Test Project II");
        this.assertInactiveSchemeExists("Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)");
        this.assertNoScheme("Copy 2 of Source Workflow Scheme");
        this.assertSchemeIdChanged("Source Workflow Scheme", 10000L);
    }

    @Test
    @Restore(value="WorkflowMigrationHalfMigratedDataNewDestinationMultiple.xml")
    public void testWorkflowMigrationHalfMigratedDataNewDestinationInTheFirstProject() throws SAXException {
        this.tester.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep2!default.jspa?draftMigration=true&projectId=10010&schemeId=10000");
        this.tester.assertTextPresent("Step 1 of 2");
        this.tester.assertTextPresent("The current status of each issue needs to be changed so that it is compatible with the new workflows.");
        this.tester.assertTextPresent("Affected issues: 6 of 12");
        this.tester.assertTextPresent("Affected issues: 10 of 20");
        this.tester.assertTextPresent("Affected issues: 2 of 12");
        this.assertMappingAndSelectOptionsForHalfMigratedDataNewDestination();
        this.tester.submit("Associate");
        this.administration.project().waitForWorkflowMigration(1000L, 100);
        this.assertIssuesInHomosapienProjectAfterHalfMigratedDataNewDestination();
        this.checkIssuesInTestIIProjectAfterHalfMigratedDataNewDestination();
        this.checkIssuesInTestProjectAfterHalfMigratedDataNewDestination();
        this.assertScheme("homosapien", "Homosapien Source Scheme", "The original workflow scheme of the Homosapien project", (Map<String, String>)ImmutableMap.of((Object)"Custom Issue Type", (Object)"Homosapien Custom Issue Type Destination", (Object)"Improvement", (Object)"jira"), "Homospien Destination");
        this.assertScheme("Test Project II", "Homosapien Source Scheme", "The original workflow scheme of the Homosapien project", (Map<String, String>)ImmutableMap.of((Object)"Custom Issue Type", (Object)"Homosapien Custom Issue Type Destination", (Object)"Improvement", (Object)"jira"), "Homospien Destination");
        this.assertNoDraft("homosapien");
        this.assertNoDraft("Test Project II");
        this.assertInactiveSchemeExists("Copy of Homosapien Source Scheme", "The original workflow scheme of the Homosapien project (This copy was automatically generated from a draft, as an intermediate scheme for migration)");
        this.assertNoScheme("Copy 2 of Homosapien Source Scheme");
        this.assertSchemeIdChanged("Homosapien Source Scheme", 10010L);
    }

    private void checkIssuesInTestIIProjectAfterHalfMigratedDataNewDestination() {
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 3").addTransitions("Go custom 4").addHistoryItems(TestDraftWorkflowSchemeMultipleProjectsMigration.item("Workflow", "Homosapien Source 1", "Homospien Destination"), TestDraftWorkflowSchemeMultipleProjectsMigration.item("status", "Custom Status 1", "Custom Status 3")).assertIssue(this.getIssue("TSTII-2"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 4").addTransitions("Resolve").addHistoryItems(TestDraftWorkflowSchemeMultipleProjectsMigration.item("Workflow", "Homosapien Source 1", "Homospien Destination"), TestDraftWorkflowSchemeMultipleProjectsMigration.item("status", "Custom Status 2", "Custom Status 4")).assertIssue(this.getIssue("TSTII-3"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("In Progress").addTransitions("Stop Progress", "Close Issue", "Resolve Issue").addHistoryItems(TestDraftWorkflowSchemeMultipleProjectsMigration.item("Workflow", "Homosapien Source 2", "jira"), TestDraftWorkflowSchemeMultipleProjectsMigration.item("status", "Custom Status 1", "In Progress")).assertIssue(this.getIssue("TSTII-10"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Resolved").addTransitions("Close Issue", "Reopen Issue").addHistoryItems(TestDraftWorkflowSchemeMultipleProjectsMigration.item("Workflow", "Homosapien Source 2", "jira"), TestDraftWorkflowSchemeMultipleProjectsMigration.item("status", "Custom Status 3", "Resolved")).assertIssue(this.getIssue("TSTII-11"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 3").addTransitions("Go custom 4").addHistoryItems(TestDraftWorkflowSchemeMultipleProjectsMigration.item("Workflow", "Homosapien Source 1", "Homospien Destination"), TestDraftWorkflowSchemeMultipleProjectsMigration.item("status", "Custom Status 1", "Custom Status 3")).assertIssue(this.getIssue("TSTII-20"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 4").addTransitions("Resolve").addHistoryItems(TestDraftWorkflowSchemeMultipleProjectsMigration.item("Workflow", "Homosapien Source 1", "Homospien Destination"), TestDraftWorkflowSchemeMultipleProjectsMigration.item("status", "Custom Status 2", "Custom Status 4")).assertIssue(this.getIssue("TSTII-21"), false);
    }

    @Test
    @Restore(value="WorkflowMigrationTestIssueVerifierMultipleErrorsInTst.xml")
    public void testIssueVerifierErrorInOneProject() {
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, false);
        this.waitForFailedMigration();
        this.assertIssueVerifierErrorMessages("TST");
        this.assertDraft("Test Project");
        this.assertStandardIssues("TSTII");
        this.assertNoDraft("Test Project II");
        this.assertScheme("Test Project", "Source Workflow Scheme", "The workflow scheme the project started on", SOURCE_SCHEME_WORKFLOW_MAPPING, "Source Workflow 1");
        this.assertScheme("Test Project II", "Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)", DRAFT_WORKFLOW_MAPPING, "Destinatiom Workflow");
        this.assertSchemeId("Source Workflow Scheme", 10000L);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=711000)
    @Restore(value="WorkflowMigrationTestIssueVerifierMultipleErrorsInBoth.xml")
    public void testIssueVerifierErrorInBothProjects() {
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, false);
        this.waitForFailedMigration();
        this.assertIssueVerifierErrorMessages("TST");
        this.assertIssueVerifierErrorMessages("TSTII");
        this.assertInactiveSchemeExists("Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)");
        this.assertDraft("Test Project");
        this.assertDraft("Test Project II");
        this.assertScheme("Test Project", "Source Workflow Scheme", "The workflow scheme the project started on", SOURCE_SCHEME_WORKFLOW_MAPPING, "Source Workflow 1");
        this.assertScheme("Test Project II", "Source Workflow Scheme", "The workflow scheme the project started on", SOURCE_SCHEME_WORKFLOW_MAPPING, "Source Workflow 1");
        this.assertSchemeId("Source Workflow Scheme", 10000L);
    }

    @Test
    @Restore(value="WorkflowSchemePublishingMultipleMigrationTest.xml")
    public void testMigrateMultipleProjectsIfNewProjectIsAssociatedWithTheScheme() {
        this.tester.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep2!default.jspa?draftMigration=true&projectId=10000&schemeId=10100");
        this.associateNewProjectToScheme(10000L);
        this.tester.submit("Associate");
        this.administration.project().waitForWorkflowMigration(1000L, 100);
        this.assertScheme("Test Project", "Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)", DRAFT_WORKFLOW_MAPPING, "Destinatiom Workflow");
        this.assertScheme("Test Project II", "Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)", DRAFT_WORKFLOW_MAPPING, "Destinatiom Workflow");
        this.assertSchemeId("Source Workflow Scheme", 10000L);
    }

    private void associateNewProjectToScheme(long schemeId) {
        this.backdoor.project().addProject("Test Project III", "TSTIII", "admin");
        this.backdoor.project().setWorkflowScheme("TSTIII", schemeId);
    }

    @Test
    @Restore(value="WorkflowMigrationTwoAdminsMultiple.xml")
    public void testMultiAdminTaskProgressFlowMultipleProjects() {
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, false);
        this.assertMultiAdminTaskProgressFlow(10000L);
    }

    @Test
    @Restore(value="WorkflowMigrationTwoAdminsMultiple.xml")
    public void testMultiAdminTaskProgressFlowMultipleProjectsGoToSecondProject() {
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, false);
        this.assertMultiAdminTaskProgressFlow(10010L);
    }
}

