/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.CommentAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
public class TestTransitionWorkflowScreen
extends BaseJiraFuncTest {
    public static final String DEVMAN_USERNAME = "devman";
    public static final String ADMINMAN_USERNAME = "adminman";
    private static final String COMMENT_VALUE = "i should survive the error";
    private static final String COMMENT_1 = "This issue is resolved now.";
    private static final String COMMENT_2 = "Viewable by developers group.";
    private static final String COMMENT_3 = "Viewable by Developers role.";
    private static final String COMMENT_4 = "Viewable by jira-administrators role.";
    private static final String COMMENT_5 = "Viewable by Administrators role.";
    private static final String HSP_1 = "HSP-1";
    private static final String HSP_2 = "HSP-2";
    private static final String HSP_3 = "HSP-3";
    private static final String HSP_4 = "HSP-4";
    private static final String HSP_5 = "HSP-5";
    public static final String ACTION_ID_DONE = "action_id_51";
    public static final String ACTION_ID_STOP_PROGRESS = "action_id_41";
    public static final String ACTION_ID_START_PROGRESS = "action_id_31";
    public static final String ACTION_ID_OPEN = "action_id_11";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private WorkflowUtil workflowUtil;

    @Test
    @Restore(value="TestTransitionWorkflowScreen.xml")
    public void testCommentValueRemainsOnError() {
        this.navigation.comment().enableCommentGroupVisibility(Boolean.TRUE);
        String issueKey = HSP_1;
        this.navigation.issue().gotoIssue(HSP_1);
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("summary", "");
        this.tester.setFormElement("comment", COMMENT_VALUE);
        this.tester.selectOption("commentLevel", "jira-developers");
        this.tester.submit("Transition");
        this.tester.assertTextPresent("You must specify a summary of the issue");
        this.tester.assertTextPresent(COMMENT_VALUE);
        this.tester.setFormElement("summary", "summary of resolving issue");
        this.tester.submit("Transition");
        CommentAssertions commentAssertions = this.assertions.comments(COMMENT_VALUE);
        commentAssertions.areNotVisibleTo("fred", HSP_1);
        commentAssertions.areVisibleTo("admin", HSP_1);
    }

    @Test
    @Restore(value="TestTransitionWorkflowScreen.xml")
    public void testTransitionIssueForTheCommentVisibility() {
        this.navigation.comment().enableCommentGroupVisibility(Boolean.TRUE);
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText(HSP_1);
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("comment", COMMENT_1);
        this.tester.submit("Transition");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText(HSP_2);
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("comment", COMMENT_2);
        this.tester.selectOption("commentLevel", "jira-developers");
        this.tester.submit("Transition");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText(HSP_3);
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("comment", COMMENT_3);
        this.tester.selectOption("commentLevel", "Developers");
        this.tester.submit("Transition");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText(HSP_4);
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("comment", COMMENT_4);
        this.tester.selectOption("commentLevel", "Administrators");
        this.tester.submit("Transition");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText(HSP_5);
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("comment", COMMENT_5);
        this.tester.selectOption("commentLevel", "jira-administrators");
        this.tester.submit("Transition");
        this.assertions.comments(COMMENT_1).areVisibleTo("fred", HSP_1);
        this.assertions.comments(COMMENT_2).areNotVisibleTo("fred", HSP_2);
        this.assertions.comments(COMMENT_3).areNotVisibleTo("fred", HSP_3);
        this.assertions.comments(COMMENT_1).areVisibleTo("admin", HSP_1);
        this.assertions.comments(COMMENT_2).areVisibleTo("admin", HSP_2);
        this.assertions.comments(COMMENT_3).areVisibleTo("admin", HSP_3);
        this.assertions.comments(COMMENT_2).areVisibleTo(DEVMAN_USERNAME, HSP_2);
        this.assertions.comments(COMMENT_3).areVisibleTo(DEVMAN_USERNAME, HSP_3);
        this.assertions.comments(COMMENT_4).areNotVisibleTo(DEVMAN_USERNAME, HSP_4);
        this.assertions.comments(COMMENT_5).areNotVisibleTo(DEVMAN_USERNAME, HSP_5);
        this.assertions.comments(COMMENT_2).areNotVisibleTo(ADMINMAN_USERNAME, HSP_2);
        this.assertions.comments(COMMENT_3).areNotVisibleTo(ADMINMAN_USERNAME, HSP_3);
        this.assertions.comments(COMMENT_4).areVisibleTo(ADMINMAN_USERNAME, HSP_4);
        this.assertions.comments(COMMENT_5).areVisibleTo(ADMINMAN_USERNAME, HSP_5);
    }

    @Test
    @Restore(value="TestWorkflowComments.xml")
    public void testCommentWhileTransitioningIssue() {
        this.logger.log((Object)"testTransitionFromStatusThatAllowsCommentsToOneThatDoes");
        this.testCommentWhileTransitioning(ACTION_ID_OPEN, "TEST-1");
        this.logger.log((Object)"testTransitionFromStatusThatAllowsCommentsToOneThatDoesNot");
        this.testCommentWhileTransitioning(ACTION_ID_START_PROGRESS, "TEST-2");
        this.logger.log((Object)"testTransitionFromStatusThatDoesNotAllowCommentsToOneThatDoes");
        this.testCommentWhileTransitioning(ACTION_ID_STOP_PROGRESS, "TEST-4");
        this.logger.log((Object)"testTransitionFromStatusThatDoesNotAllowCommentsToOneThatDoesNot");
        this.transitionFromStatusThatDoesNotAllowCommentsToOneThatDoesNot();
    }

    private void transitionFromStatusThatDoesNotAllowCommentsToOneThatDoesNot() {
        this.navigation.issue().gotoIssue("TEST-3");
        this.workflowUtil.clickAction(ACTION_ID_DONE);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.assertFormElementNotPresent("comment");
    }

    private void testCommentWhileTransitioning(String actionId, String issueKey) {
        this.navigation.issue().gotoIssue(issueKey);
        this.workflowUtil.clickAction(actionId);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("comment", COMMENT_VALUE);
        this.tester.submit("Transition");
        this.assertions.comments(COMMENT_VALUE).areVisibleTo("admin", issueKey);
    }
}

