/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Indexing;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
@Restore(value="TestWorkflowActions.xml")
public class TestWorkFlowActions
extends BaseJiraFuncTest {
    public static final String PROJECT_KEY = "HSP";
    public static final String issueKey = "HSP-1";
    private static final String DODGY_WORKFLOW_NAME = "'><script>altert('hello')</script>";
    @Inject
    private Indexing indexing;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testCopyWorkflowWithXSS() {
        this.administration.workflows().goTo().addWorkflow(DODGY_WORKFLOW_NAME, "Some desc");
        this.administration.workflows().goTo();
        this.tester.clickLink("copy_'><script>altert('hello')</script>");
        this.tester.assertTextPresent("&#39;&gt;&lt;script&gt;altert(&#39;hello&#39;)&lt;/script&gt;");
        this.tester.setFormElement("newWorkflowName", "Copy of '><script>altert('hello')</script>");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Copy of &#39;&gt;&lt;script&gt;altert(&#39;hello&#39;)&lt;/script&gt;");
    }

    @Test
    public void testWorkFlowActions() {
        try {
            this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
            this.assignIssue(issueKey);
        }
        finally {
            this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        }
        this.resolveIssue(issueKey);
        this.closeAndReopenIssue(issueKey);
        this.closeIssueFromOpen(issueKey);
        this.navigation.issue().deleteIssue(issueKey);
    }

    @Test
    public void testInvalidWorkflowAction() throws Exception {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.gotoPage("/secure/WorkflowUIDispatcher.jspa?id=10000&action=3&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent("Workflow Action Invalid");
        this.tester.assertTextPresent("Reopen Issue");
        this.tester.assertLinkPresent("refreshIssue");
    }

    @Test
    public void testInvalidWorkflowActionDoesNotBreakThePage() throws Exception {
        this.administration.restoreData("TestWorkflowActionsDodgyWorkflow.xml");
        this.navigation.issue().viewIssue("TST-1");
        this.tester.assertTextPresent("Details");
        this.tester.assertLinkNotPresentWithText("Close Issue");
        this.tester.assertLinkNotPresentWithText("Resolve Issue");
    }

    @Test
    public void testWorkflowWithReturnUrl() throws UnsupportedEncodingException {
        this.tester.gotoPage("/secure/WorkflowUIDispatcher.jspa?id=10000&action=5&atl_token=" + this.page.getXsrfToken() + "&returnUrl=%2Fissues%2F%3Fjql%3Dproject%2B%3D%2BHSP%26selectedIssueId%3D10000");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        String currentUrl = URLDecoder.decode(this.tester.getDialog().getResponse().getURL().toExternalForm(), "UTF-8");
        Assert.assertThat((String)"Did not get redirected to the issue navigator.", (Object)currentUrl, (Matcher)Matchers.containsString((String)"/issues/?jql=project = HSP"));
    }

    public void assignIssue(String issueKey) {
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        try {
            this.administration.usersAndGroups().addUserToGroup("bob", "jira-developers");
        }
        catch (Throwable t) {
            this.logger.log((Object)"bob is already part of jira-developers");
        }
        this.navigation.issue().assignIssue(issueKey, "issue assigned", "Bob The Builder");
        this.administration.usersAndGroups().removeUserFromGroup("bob", "jira-developers");
        this.navigation.issue().assignIssue(issueKey, "issue assigned", "Administrator");
    }

    public void resolveIssue(String issueKey) {
        this.indexing.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Open", (Object)"resolution", (Object)"Unresolved", (Object)"key", (Object)issueKey), null, issueKey);
        this.progressAndResolve(issueKey, 5, "issue resolved");
        this.indexing.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Resolved", (Object)"resolution", (Object)"Fixed", (Object)"key", (Object)issueKey), null, issueKey);
    }

    public void closeAndReopenIssue(String issueKey) {
        this.indexing.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Resolved", (Object)"resolution", (Object)"Fixed", (Object)"key", (Object)issueKey, (Object)"version", (Object)"New Version 1"), null, issueKey);
        this.progressWorkflow(issueKey, 701, "issue closed");
        this.indexing.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Closed", (Object)"key", (Object)issueKey), null, issueKey);
        this.progressWorkflow(issueKey, 3, "issue reopened");
        this.indexing.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Reopened", (Object)"key", (Object)issueKey), null, issueKey);
    }

    public void closeIssueFromOpen(String issueKey) {
        this.progressAndResolve(issueKey, 2, "issue resolved and closed");
        this.progressWorkflow(issueKey, 3, "issue reopened");
    }

    @Test
    public void testDeleteWorkflowLinkShownIfWorkflowIsUnassigned() {
        this.addWorkflow();
        this.administration.workflows().goTo();
        String deleteLinkId = this.getDeleteLinkId();
        this.tester.assertLinkPresent(deleteLinkId);
    }

    @Test
    public void testDeleteWorkflowLinkIsNotShownIfWorkflowIsAssignedToScheme() {
        this.addWorkflow();
        this.assignToScheme();
        this.administration.workflows().goTo();
        String deleteLinkId = this.getDeleteLinkId();
        this.tester.assertLinkNotPresent(deleteLinkId);
    }

    @Test
    public void testDeleteWorkflowLinkIsNotShownIfWorkflowIsAssignedToDraftScheme() {
        this.addWorkflow();
        this.assignToDraftScheme();
        this.administration.workflows().goTo();
        String deleteLinkId = this.getDeleteLinkId();
        this.tester.assertLinkNotPresent(deleteLinkId);
    }

    @Test
    public void testCanDeleteUnassignedWorkflow() {
        this.addWorkflow();
        this.administration.workflows().goTo();
        String deleteLinkId = this.getDeleteLinkId();
        this.tester.clickLink(deleteLinkId);
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent(DODGY_WORKFLOW_NAME);
    }

    private String getDeleteLinkId() {
        return "del_'><script>altert('hello')</script>";
    }

    @Test
    public void testCanNotDeleteWorkflowAssignedToScheme() {
        this.addWorkflow();
        this.assignToScheme();
        this.tester.gotoPage("/secure/admin/workflows/DeleteWorkflow.jspa?workflowMode=live&workflowName='><script>altert('hello')</script>&atl_token=" + this.page.getXsrfToken());
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Cannot delete workflow as it is associated with the following schemes: &#39;WF scheme&#39;");
    }

    @Test
    public void testCanNotDeleteWorkflowAssignedToDraftScheme() {
        this.addWorkflow();
        this.assignToDraftScheme();
        this.tester.gotoPage("/secure/admin/workflows/DeleteWorkflow.jspa?workflowMode=live&workflowName='><script>altert('hello')</script>&atl_token=" + this.page.getXsrfToken());
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Cannot delete workflow as it is associated with the following schemes: Draft of &#39;Default Workflow Scheme&#39;");
    }

    @Test
    public void testCanNotDeleteSystemWorkflow() {
        this.tester.gotoPage("/secure/admin/workflows/DeleteWorkflow.jspa?workflowMode=live&workflowName=jira&atl_token=" + this.page.getXsrfToken());
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Workflow cannot be deleted as it is not editable.");
    }

    @Test
    public void testErrorIsShownIfTryingToDeleteNonExistingWorkflow() {
        this.tester.gotoPage("/secure/admin/workflows/DeleteWorkflow.jspa?workflowMode=live&workflowName=Not existing WF&atl_token=" + this.page.getXsrfToken());
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Workflow with name &#39;&#39;Not existing WF&#39;&#39; does not exist.");
    }

    private void addWorkflow() {
        this.administration.workflows().goTo().addWorkflow(DODGY_WORKFLOW_NAME, "desc");
    }

    private void assignToScheme() {
        this.backdoor.workflowSchemes().createScheme(new WorkflowSchemeData().setName("WF scheme").setDescription("desc").setMapping("1", DODGY_WORKFLOW_NAME));
    }

    private void assignToDraftScheme() {
        this.administration.project().createWorkflowSchemeDraft(PROJECT_KEY);
        this.administration.project().assignToDraftScheme(PROJECT_KEY, DODGY_WORKFLOW_NAME, "1");
    }

    public void progressWorkflow(String issueKey, int actionKey, String comment) {
        this.logger.log((Object)(actionKey + ": " + issueKey));
        this.changeWorkflow(issueKey, actionKey);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("comment", comment);
        this.tester.submit("Transition");
        this.tester.assertTextPresent(comment);
    }

    public void progressAndResolve(String issueKey, int actionKey, String comment) {
        this.logger.log((Object)(actionKey + ": " + issueKey));
        this.changeWorkflow(issueKey, actionKey);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("comment", comment);
        this.tester.selectOption("resolution", "Fixed");
        this.tester.submit("Transition");
        this.tester.assertTextPresent(comment);
    }

    public void changeWorkflow(String issueKey, int actionKey) {
        this.navigation.issue().gotoIssue(issueKey);
        this.workflowUtil.clickAction("action_id_" + actionKey);
    }
}

