/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import javax.inject.Inject;
import org.apache.oro.text.regex.MalformedPatternException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
public class TestWorkflowConditions
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testProjectRoleWorkflowCondition() throws MalformedPatternException {
        this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira").textView().goTo();
        this.tester.clickLinkWithText("Start Progress");
        this.tester.clickLinkWithText("Add condition", 0);
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:isuserinprojectrole-condition");
        this.tester.submit("Add");
        this.tester.selectOption("jira.projectrole.id", "Users");
        this.tester.submit("Add");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Only users in project role ", "Users", " can execute this transition."});
        this.tester.clickLink("workflow-steps");
        this.tester.clickLinkWithText("Stop Progress");
        this.tester.clickLinkWithText("Add condition", 0);
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:isuserinprojectrole-condition");
        this.tester.submit("Add");
        this.tester.selectOption("jira.projectrole.id", "Developers");
        this.tester.submit("Add");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Only users in project role ", "Developers", " can execute this transition."});
        this.tester.gotoPage("/secure/admin/workflows/EditWorkflowTransitionConditionParams!default.jspa?workflowStep=1&workflowTransition=4&count=2&workflowName=Copy+of+jira&workflowMode=live");
        this.tester.selectOption("jira.projectrole.id", "Administrators");
        this.tester.submit("Update");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Only users in project role ", "Administrators", " can execute this transition."});
        this.tester.clickLinkWithText("Delete");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.setFormElement("name", "");
        this.tester.clickLink("view_Administrators");
        this.tester.clickLinkWithText("Start Progress");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Only users in project role ", "Administrators", " can execute this transition."});
    }

    @Test
    public void testGroupCFAddCondition() {
        this.createGroupPickerCF("CF_GP1");
        this.createGroupPickerCF("CF_GP2");
        this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira").textView().goTo();
        this.tester.clickLinkWithText("Start Progress");
        this.tester.clickLinkWithText("Add condition", 0);
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:isuseringroupcf-condition");
        this.tester.submit("Add");
        this.tester.assertTextPresent("<select name=\"groupcf\">");
        this.tester.assertTextPresent("<option value=\"customfield_10000\"");
        this.tester.assertTextPresent("CF_GP1");
        this.tester.assertTextPresent("<option value=\"customfield_10001\"");
        this.tester.assertTextPresent("CF_GP2");
        this.tester.submit("Add");
        this.tester.gotoPage("secure/admin/workflows/EditWorkflowTransitionConditionParams!default.jspa?workflowStep=1&workflowTransition=4&count=2&workflowName=Copy+of+jira&workflowMode=live");
        this.tester.assertTextPresent("<select name=\"groupcf\">");
        this.tester.assertTextPresent("<option value=\"customfield_10000\"");
        this.tester.assertTextPresent("CF_GP1");
        this.tester.assertTextPresent("<option value=\"customfield_10001\"");
        this.tester.assertTextPresent("CF_GP2");
    }

    @Test
    public void testPermissionCondition() {
        this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira").textView().goTo();
        this.tester.clickLinkWithText("Start Progress");
        this.tester.clickLinkWithText("Add condition", 0);
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:permission-condition");
        this.tester.submit("Add");
        this.tester.selectOption("permissionKey", "Resolve Issues");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Resolve Issues");
        this.tester.gotoPage("/secure/admin/workflows/EditWorkflowTransitionConditionParams!default.jspa?workflowMode=live&workflowStep=1&workflowTransition=4&count=2&workflowName=Copy+of+jira");
        this.tester.assertRadioOptionSelected("permissionKey", ProjectPermissions.RESOLVE_ISSUES.permissionKey());
        this.tester.assertTextNotPresent("NullPointerException");
        this.tester.selectOption("permissionKey", "Modify Reporter");
        this.tester.submit("Update");
        Assert.assertThat((Object)this.tester.getDialog().getElement("workflow-transition-info").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Resolve Issues")));
        this.tester.assertTextPresent("Modify Reporter");
    }

    private void createGroupPickerCF(String fieldName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:grouppicker");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", fieldName);
        this.tester.submit("nextBtn");
        this.tester.submit("Update");
    }
}

