/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TableAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.table.AndCell;
import com.atlassian.jira.webtests.table.EmptyCell;
import com.atlassian.jira.webtests.table.LinkCell;
import com.atlassian.jira.webtests.table.StrictTextCell;
import com.atlassian.jira.webtests.table.TextCell;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
public class TestWorkflowEditor
extends BaseJiraFuncTest {
    private static final String WORKFLOW_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE workflow PUBLIC \"-//OpenSymphony Group//DTD OSWorkflow 2.8//EN\" \"http://www.opensymphony.com/osworkflow/workflow_2_8.dtd\">\n<workflow>\n  <meta name=\"jira.update.author.key\">admin</meta>\n  <meta name=\"jira.description\"></meta>\n  <meta name=\"jira.updated.date\">1196830052833</meta>\n  <initial-actions>\n    <action id=\"1\" name=\"Create\">\n      <validators>\n        <validator name=\"\" type=\"class\">\n          <arg name=\"class.name\">com.atlassian.jira.workflow.validator.PermissionValidator</arg>\n          <arg name=\"permission\">Create Issue</arg>\n        </validator>\n      </validators>\n      <results>\n        <unconditional-result old-status=\"null\" status=\"open\" step=\"1\">\n          <post-functions>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueCreateFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>\n              <arg name=\"eventTypeId\">1</arg>\n            </function>\n          </post-functions>\n        </unconditional-result>\n      </results>\n    </action>\n  </initial-actions>\n  <steps>\n    <step id=\"1\" name=\"Open\">\n      <meta name=\"jira.status.id\">1</meta>\n    </step>\n  </steps>\n</workflow>";
    @Inject
    protected HtmlPage page;
    TableAssertions tableAssertions;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreData("TestWorkflowEditor.xml");
        this.tableAssertions = new TableAssertions(this.tester, this.environmentData);
    }

    @Test
    public void testWorkflowListingEnterprise() {
        this.administration.workflows().goTo();
        Assert.assertEquals((long)2L, (long)this.getWebTableWithID("active-workflows-table").getRowCount());
        this.assertions.getTableAssertions().assertTableRowEquals(this.getWebTableWithID("active-workflows-table"), 0, new Object[]{new TextCell("Name"), new TextCell("Last modified"), new TextCell("Assigned Schemes"), new TextCell("Steps"), new TextCell("Actions")});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("active-workflows-table"), new Object[]{"Workflow1", new TextCell("05/Dec/07", "Administrator"), new LinkCell("EditWorkflowScheme.jspa?schemeId=10010", "WorkflowScheme_Workflow1"), new TextCell("1"), new AndCell(new XsrfLinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=Workflow1", "View"), new XsrfLinkCell("EditWorkflowDispatcher.jspa?wfName=Workflow1", "Edit"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Workflow1", "Copy"))});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("inactive-workflows-table"), new Object[]{new TextCell(new String[]{"jira", "Read-only System Workflow", "Default", "The default Jira workflow"}), new EmptyCell(), new EmptyCell(), new TextCell("5"), new AndCell(new XsrfLinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=jira", "View"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=jira", "Copy"))});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("inactive-workflows-table"), new Object[]{"Workflow2", new TextCell("05/Dec/07", "Administrator"), new EmptyCell(), new TextCell("1"), new AndCell(new XsrfLinkCell("EditWorkflowDispatcher.jsp?wfName=Workflow2", "Edit"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Workflow2", "Copy"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=Workflow2", "Delete"))});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("inactive-workflows-table"), new Object[]{"Workflow3", new TextCell("05/Dec/07", "Administrator"), new EmptyCell(), new TextCell("1"), new AndCell(new XsrfLinkCell("EditWorkflowDispatcher.jsp?wfName=Workflow3", "Edit"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Workflow3", "Copy"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=Workflow3", "Delete"))});
        this.tester.clickLink("copy_Workflow3");
        this.tester.assertTextPresent("Copy Workflow: Workflow3");
        this.tester.setFormElement("newWorkflowName", "XX Copy Of Workflow3");
        this.tester.setFormElement("description", "Description of Workflow 3 copy");
        this.tester.submit("Update");
        SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yy");
        this.administration.workflows().goTo();
        this.tester.assertTextPresent("Workflows");
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("inactive-workflows-table"), new Object[]{"XX Copy Of Workflow3", new TextCell(format.format(new Date()), "Administrator"), new EmptyCell(), new TextCell("1"), new AndCell(new XsrfLinkCell("EditWorkflowDispatcher.jsp?wfName=XX+Copy+Of+Workflow3", "Edit"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=XX+Copy+Of+Workflow3", "Copy"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=XX+Copy+Of+Workflow3", "Delete"))});
        this.tester.clickLink("del_Workflow2");
        this.tester.assertTextPresent("Delete Workflow");
        this.tester.assertTextPresent("Confirm that you want to delete the workflow <strong>Workflow2</strong>.");
        this.tester.assertLinkPresentWithText("do a full backup");
        this.tester.assertLinkPresentWithText("export");
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent("Workflow2");
        this.tester.clickLink("edit_live_Workflow3");
        this.tester.clickLink("xml_Workflow3");
        Assert.assertEquals((long)200L, (long)this.tester.getDialog().getResponse().getResponseCode());
        this.administration.workflows().goTo();
        this.tester.clickLink("add-workflow");
        this.tester.setFormElement("newWorkflowName", "ZZ This is a new Workflow!");
        this.tester.setFormElement("description", "A new Workflow.");
        this.tester.submit("Add");
        this.administration.workflows().goTo();
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("inactive-workflows-table"), new Object[]{"ZZ This is a new Workflow!", new TextCell(format.format(new Date()), "Administrator"), new EmptyCell(), new TextCell("1"), new AndCell(new XsrfLinkCell("EditWorkflowDispatcher.jsp?wfName=ZZ+This+is+a+new+Workflow%21", "Edit"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=ZZ+This+is+a+new+Workflow%21", "Copy"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=ZZ+This+is+a+new+Workflow%21", "Delete"))});
        this.tester.clickLinkWithText("Import XML");
        this.tester.setFormElement("name", "ZZZ Imported workflow");
        this.tester.setFormElement("description", "This was imported from XML!");
        this.tester.setFormElement("workflowXML", "Invalid input");
        this.tester.setFormElement("definition", "inline");
        this.tester.submit("Import");
        this.tester.assertTextPresent("Error parsing workflow XML");
        this.tester.setFormElement("workflowXML", WORKFLOW_XML);
        this.tester.submit("Import");
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("inactive-workflows-table"), new Object[]{new TextCell("ZZZ Imported workflow", "This was imported from XML!"), new TextCell(format.format(new Date()), "Administrator"), new EmptyCell(), new TextCell("1"), new AndCell(new XsrfLinkCell("EditWorkflowDispatcher.jsp?wfName=ZZZ+Imported+workflow", "Edit"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=ZZZ+Imported+workflow", "Copy"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=ZZZ+Imported+workflow", "Delete"))});
    }

    private WebTable getWebTableWithID(String id) {
        return this.tester.getDialog().getWebTableBySummaryOrId(id);
    }

    @Test
    public void testViewWorkflowSteps() {
        this.administration.workflows().goTo().workflowSteps("Workflow3");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Edit Workflow", "Workflow3"});
        Assert.assertEquals((long)2L, (long)this.getWebTableWithID("steps_table").getRowCount());
        this.assertions.getTableAssertions().assertTableRowEquals(this.getWebTableWithID("steps_table"), 0, new Object[]{new TextCell("Step Name", "(id)"), new TextCell("Linked Status"), new TextCell("Transitions", "(id)"), new TextCell("Actions")});
        this.assertions.getTableAssertions().assertTableRowEquals(this.getWebTableWithID("steps_table"), 1, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=1", "Open"), new TextCell("(1)")), new TextCell("Open"), new StrictTextCell(""), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=1", "Add transition"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=1", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=1", "View Properties"))});
        this.tester.setFormElement("stepName", "");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Step name must be specified.");
        this.tester.setFormElement("stepName", "Resolved");
        this.tester.selectOption("stepStatus", "Resolved");
        this.tester.submit("Add");
        this.assertions.getTableAssertions().assertTableRowEquals(this.getWebTableWithID("steps_table"), 2, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Resolved"), new TextCell("(2)")), new TextCell("Resolved"), new StrictTextCell(""), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Add transition"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "View Properties"), new XsrfLinkCell("DeleteWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Step"))});
        this.tester.clickLink("add_trans_2");
        this.tester.setFormElement("transitionName", "Re-open");
        this.tester.setFormElement("description", "This transition re-opens a resolved issue.");
        this.tester.selectOption("view", "Default Screen");
        this.tester.submit("Add");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Edit Workflow", "Workflow3"});
        this.assertions.getTableAssertions().assertTableRowEquals(this.getWebTableWithID("steps_table"), 2, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Resolved"), new TextCell("(2)")), new TextCell("Resolved"), new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow3&workflowTransition=11&workflowStep=2", "Re-open"), new TextCell("(11)", "Open")), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Add transition"), new XsrfLinkCell("DeleteWorkflowTransitions!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Transitions"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "View Properties"), new XsrfLinkCell("DeleteWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Step"))});
        this.tester.clickLink("edit_step_2");
        this.tester.assertTextPresent("Update Workflow Step");
        this.tester.assertTextPresent("This page allows you to update the <b>Resolved</b> step.");
        this.tester.setFormElement("stepName", "Actually Closed");
        this.tester.selectOption("stepStatus", "Closed");
        this.tester.submit("Update");
        this.assertions.getTableAssertions().assertTableRowEquals(this.getWebTableWithID("steps_table"), 2, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Actually Closed"), new TextCell("(2)")), new TextCell("Closed"), new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow3&workflowTransition=11&workflowStep=2", "Re-open"), new TextCell("(11)", "Open")), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Add transition"), new XsrfLinkCell("DeleteWorkflowTransitions!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Transitions"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "View Properties"), new XsrfLinkCell("DeleteWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Step"))});
        this.tester.clickLink("add_trans_2");
        this.tester.assertTextPresent("Add Workflow Transition");
        this.tester.assertTextPresent("Create a transition from <b>Actually Closed</b> to another step.");
        this.tester.setFormElement("transitionName", "Closed it again");
        this.tester.setFormElement("description", "");
        this.tester.selectOption("destinationStep", "Actually Closed");
        this.tester.submit("Add");
        this.assertions.getTableAssertions().assertTableRowEquals(this.getWebTableWithID("steps_table"), 2, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Actually Closed"), new TextCell("(2)")), new TextCell("Closed"), new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow3&workflowTransition=11&workflowStep=2", "Re-open"), new TextCell("(11)", "Open"), new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow3&workflowTransition=21&workflowStep=2", "Closed it again"), new TextCell("21", "Closed")), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Add transition"), new XsrfLinkCell("DeleteWorkflowTransitions!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Transitions"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "View Properties"))});
        this.tester.clickLink("del_trans_2");
        this.tester.assertTextPresent("Delete Workflow Transitions");
        this.tester.assertTextPresent("Please select transitions to delete from the <b>Actually Closed</b> step.");
        this.tester.selectOption("transitionIds", "Closed it again");
        this.tester.submit("Delete");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Edit Workflow", "Workflow3"});
        this.tester.assertTextNotPresent("Closed it again");
    }

    @Test
    public void testStepProperties() {
        this.administration.workflows().goTo().workflowSteps("Workflow2");
        this.tester.clickLinkWithText("View Properties");
        this.tester.assertTextPresent("View Workflow Step Properties: Open");
        this.tester.assertLinkPresentWithText("workflow steps");
        this.tester.assertTextPresent("There are currently no defined properties.");
        this.tester.assertTextPresent("Add New Property");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Key must be set.");
        this.tester.setFormElement("attributeKey", "test.key");
        this.tester.setFormElement("attributeValue", "");
        this.tester.submit("Add");
        this.tester.assertTextNotPresent("There are currently no defined properties.");
        Assert.assertEquals((long)2L, (long)this.getWebTableWithID("metas_table").getRowCount());
        this.tableAssertions.assertTableRowEquals(this.getWebTableWithID("metas_table"), 0, new Object[]{new TextCell("Property Key"), new TextCell("Property Value"), new TextCell("Operations")});
        this.tableAssertions.assertTableRowEquals(this.getWebTableWithID("metas_table"), 1, new Object[]{new TextCell("test.key"), new StrictTextCell(""), new XsrfLinkCell("RemoveWorkflowStepMetaAttribute.jspa?workflowName=Workflow2&workflowMode=live&workflowStep=1&attributeKey=test.key", "Delete")});
        this.tester.setFormElement("attributeKey", "another.key");
        this.tester.setFormElement("attributeValue", "This is a value.");
        this.tester.submit("Add");
        this.tester.assertTextNotPresent("There are currently no defined properties.");
        Assert.assertEquals((long)3L, (long)this.getWebTableWithID("metas_table").getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("metas_table"), new Object[]{new TextCell("another.key"), new StrictTextCell("This is a value."), new XsrfLinkCell("RemoveWorkflowStepMetaAttribute.jspa?workflowName=Workflow2&workflowMode=live&workflowStep=1&attributeKey=another.key", "Delete")});
        this.tester.setFormElement("attributeKey", "another.key");
        this.tester.submit("Add");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("Key 'another.key' already exists.");
        this.tester.clickLink("del_meta_another.key");
        Assert.assertEquals((long)2L, (long)this.getWebTableWithID("metas_table").getRowCount());
        this.tester.assertTextNotPresent("another.key");
        this.tester.assertTextNotPresent("This is a value.");
    }

    @Test
    public void testEditSingleStepAndTransition() {
        this.administration.workflows().goTo().workflowSteps("Workflow2").add("Resolved", "Resolved");
        this.navigation.clickLinkWithExactText("Open");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-page-header-main h2"), "Step: Open");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_transition_1"));
        this.assertLinkPresentWithSubString("view_transition_1", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_transition_1"), "Create");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps .workflow-transition-not-found"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps .workflow-transition-not-found"), "No transitions");
        this.tester.clickLink("add_transition");
        this.tester.setFormElement("transitionName", "Resolve");
        this.tester.selectOption("destinationStep", "Resolved");
        this.tester.submit("Add");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-page-header-main h2"), "Step: Open");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_transition_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_transition_1"), "Create");
        this.assertLinkPresentWithSubString("view_transition_1", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_11"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_11"), "Resolve");
        this.assertLinkPresentWithSubString("view_outbound_transition_11", "ViewWorkflowTransition.jspa");
        this.tester.clickLink("add_transition");
        this.tester.setFormElement("transitionName", "resolveitsomemore");
        this.tester.selectOption("destinationStep", "Resolved");
        this.tester.submit("Add");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_transition_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_transition_1"), "Create");
        this.assertLinkPresentWithSubString("view_transition_1", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_11"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_11"), "Resolve");
        this.assertLinkPresentWithSubString("view_outbound_transition_11", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_21"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_21"), "resolveitsomemore");
        this.assertLinkPresentWithSubString("view_outbound_transition_21", "ViewWorkflowTransition.jspa");
        this.tester.clickLink("add_transition");
        this.tester.setFormElement("transitionName", "opensomemore");
        this.tester.submit("Add");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_transition_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_transition_1"), "Create");
        this.assertLinkPresentWithSubString("view_transition_1", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_transition_31"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_transition_31"), "opensomemore");
        this.assertLinkPresentWithSubString("view_transition_31", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_11"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_11"), "Resolve");
        this.assertLinkPresentWithSubString("view_outbound_transition_11", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_21"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_21"), "resolveitsomemore");
        this.assertLinkPresentWithSubString("view_outbound_transition_21", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_31"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_31"), "opensomemore");
        this.assertLinkPresentWithSubString("view_outbound_transition_31", "ViewWorkflowTransition.jspa");
        this.tester.clickLinkWithText("resolveitsomemore");
        this.tester.assertTextPresent("Transition: resolveitsomemore");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Screen", "None", "it will happen instantly"});
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_inbound_step_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_inbound_step_1"), "Open");
        this.assertLinkPresentWithSubString("view_inbound_step_1", "ViewWorkflowStep.jspa");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".workflow-current-context .workflow-transition-lozenge"), "resolveitsomemore");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_step_2"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_step_2"), "Resolved");
        this.assertLinkPresentWithSubString("view_outbound_step_2", "ViewWorkflowStep.jspa");
        this.tester.clickLink("edit_transition");
        this.tester.setFormElement("transitionName", "resolveitalittleless");
        this.tester.submit("Update");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_inbound_step_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_inbound_step_1"), "Open");
        this.assertLinkPresentWithSubString("view_inbound_step_1", "ViewWorkflowStep.jspa");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".workflow-current-context .workflow-transition-lozenge"), "resolveitalittleless");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_step_2"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_step_2"), "Resolved");
        this.assertLinkPresentWithSubString("view_outbound_step_2", "ViewWorkflowStep.jspa");
        this.navigation.clickLinkWithExactText("Open");
        this.tester.clickLinkWithText("opensomemore");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_inbound_step_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_inbound_step_1"), "Open");
        this.assertLinkPresentWithSubString("view_inbound_step_1", "ViewWorkflowStep.jspa");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".workflow-current-context .workflow-transition-lozenge"), "opensomemore");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_step_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_step_1"), "Open");
        this.assertLinkPresentWithSubString("view_outbound_step_1", "ViewWorkflowStep.jspa");
        this.tester.clickLinkWithText("Delete");
        this.tester.assertTextPresent("Delete Workflow Transitions");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Confirm that you want to delete", "opensomemore", "transition(s)."});
        this.tester.submit("Delete");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Edit Workflow", "Workflow2"});
        this.tester.assertTextNotPresent("opensomemore");
        this.tester.assertLinkPresentWithText("Resolve");
        this.tester.assertLinkPresentWithText("resolveitalittleless");
    }

    @Test
    public void testValidatorsConditionsAndPostFunctions() {
        this.administration.workflows().goTo().workflowSteps("Workflow2");
        this.tester.clickLink("add_trans_1");
        this.tester.setFormElement("transitionName", "testtransition");
        this.tester.submit("Add");
        this.tester.clickLinkWithText("testtransition");
        this.tester.assertTextPresent("Transition: testtransition");
        this.tester.assertLinkPresentWithText("Validators");
        this.tester.assertLinkPresentWithText("Post Functions");
        this.tester.assertLinkPresentWithText("Add");
        this.tester.clickLinkWithText("Add condition", 0);
        this.tester.assertTextPresent("Add Condition To Transition");
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Only Assignee Condition"), new TextCell("Condition to allow only the assignee to execute a transition.")});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Only Reporter Condition"), new TextCell("Condition to allow only the reporter to execute a transition.")});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Permission Condition"), new TextCell("Condition to allow only users with a certain permission to execute a transition.")});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Sub-Task Blocking Condition"), new TextCell("Condition to block parent issue transition depending on sub-task status.")});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("User Is In Group"), new TextCell("Condition to allow only users in a given group to execute a transition.")});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("User Is In Group Custom Field"), new TextCell("Condition to allow only users in a custom field-specified group to execute a transition.")});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("User Is In Project Role"), new TextCell("Condition to allow only users in a given project role to execute a transition.")});
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:onlyassignee-condition");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Only the <b>assignee</b> of the issue can execute this transition.");
        this.tester.clickLinkWithText("Add condition", 0);
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:isuserinprojectrole-condition");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add Parameters To Condition");
        this.tester.assertTextPresent("Add required parameters to the Condition.");
        this.tester.selectOption("jira.projectrole.id", "Developers");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Only users in project role <b>Developers</b> can execute this transition.");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Switch to OR", "Only the <b>assignee</b> of the issue can execute this transition.", "Only users in project role <b>Developers</b> can execute this transition."});
        this.tester.clickLinkWithText("Switch to OR");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Switch to AND", "Only the <b>assignee</b> of the issue can execute this transition.", "Only users in project role <b>Developers</b> can execute this transition."});
        this.tester.clickLinkWithText("Add grouped condition");
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:onlyassignee-condition");
        this.tester.submit("Add");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Switch to AND", "Switch to OR", "Only the <b>assignee</b> of the issue can execute this transition.", "Only the <b>assignee</b> of the issue can execute this transition.", "Only users in project role <b>Developers</b> can execute this transition."});
        this.tester.clickLinkWithText("Validators");
        this.tester.clickLinkWithText("Add validator");
        this.tester.assertTextPresent("Add Validator To Transition");
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Permission Validator"), new TextCell("Validates that the user has a permission.")});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("User Permission Validator"), new TextCell("Validates that the user has a permission, where the OSWorkflow variable holding the username is configurable. Obsolete.")});
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:permission-validator");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add Parameters To Validator");
        this.tester.assertTextPresent("Add required parameters to the Validator.");
        this.tester.selectOption("permissionKey", "Assignable User");
        this.tester.submit("Add");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Add validator", "The transition requires the following criteria to be valid", "Edit", "Delete", "Only users with <b>Assignable User</b> permission can execute this transition."});
        this.tester.clickLinkWithText("Post Functions");
        this.tester.clickLinkWithText("Add post function");
        this.tester.assertTextPresent("Add Post Function To Transition");
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Assign to Current User"), new TextCell("Assigns the issue to the current user if the current user has the 'Assignable User' permission.")});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Assign to Lead Developer"), new TextCell("Assigns the issue to the project/component lead developer")});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Assign to Reporter"), new TextCell("Assigns the issue to the reporter")});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Update Issue Field"), new TextCell("Updates a simple issue field to a given value.")});
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:assigntocurrentuser-function");
        this.tester.submit("Add");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Add post function", "The following will be processed after the transition occurs", "Set issue status to the linked status of the destination workflow step.", "Assign the issue to the current user. Please note that the issue will only be assigned to the current user if the current user has the 'Assignable User' permission.", "Add a comment to an issue if one is entered during a transition.", "Update change history for an issue and store the issue in the database.", "Re-index an issue to keep indexes in sync with the database.", "Fire a", "Generic Event", "event that can be processed by the listeners."});
        this.tester.clickLinkWithText("Move Up");
        this.tester.assertLinkNotPresentWithText("Move Up");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Add post function", "The following will be processed after the transition occurs", "Assign the issue to the current user. Please note that the issue will only be assigned to the current user if the current user has the 'Assignable User' permission.", "Set issue status to the linked status of the destination workflow step.", "Add a comment to an issue if one is entered during a transition.", "Update change history for an issue and store the issue in the database.", "Re-index an issue to keep indexes in sync with the database.", "Fire a", "Generic Event", "event that can be processed by the listeners."});
        while (this.tester.getDialog().isLinkPresentWithText("Move Down")) {
            this.tester.clickLinkWithText("Move Down");
        }
        this.tester.assertLinkNotPresentWithText("Move Down");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Add post function", "The following will be processed after the transition occurs", "Set issue status to the linked status of the destination workflow step.", "Add a comment to an issue if one is entered during a transition.", "Update change history for an issue and store the issue in the database.", "Re-index an issue to keep indexes in sync with the database.", "Fire a", "Generic Event", "event that can be processed by the listeners.", "Assign the issue to the current user. Please note that the issue will only be assigned to the current user if the current user has the 'Assignable User' permission."});
    }

    private void assertLinkPresentWithSubString(String linkId, String urlSubString) {
        try {
            WebLink link = this.tester.getDialog().getResponse().getLinkWithID(linkId);
            Assert.assertNotNull((Object)link);
            if (StringUtils.isEmpty((CharSequence)link.getURLString())) {
                Assert.fail((String)("No URL for link with id [" + linkId + "]"));
            }
            boolean foundSubString = link.getURLString().contains(urlSubString);
            Assert.assertTrue((String)(link.getURLString() + " does not have substring " + urlSubString), (boolean)foundSubString);
        }
        catch (SAXException e) {
            Assert.fail((String)("Error locating weblink with id [" + linkId + "]"));
        }
    }

    private class XsrfLinkCell
    extends LinkCell {
        private XsrfLinkCell(String url, String label) {
            super(TestWorkflowEditor.this.page.addXsrfToken(url), label);
        }
    }
}

