/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
public class TestWorkflowGlobalPostFunctions
extends BaseJiraFuncTest {
    private static final String workflowName = "GlobalPostFunctions";
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.administration.restoreData("TestWorkflowGlobalPostFunctions.xml");
    }

    @Test
    public void testGlobalPostFunctionsCreatedFromCustomImportedWorkflowXMLDisplayOnOtherTab() {
        this.administration.workflows().goTo().workflowSteps(workflowName);
        this.tester.assertTextPresent("Workflow");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "h2 .workflow-name"), workflowName);
        this.tester.clickLinkWithText("Move to Intermediate");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-page-header h2"), "Move to Intermediate");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".menu-item #view_other"), "Other");
        this.tester.clickLink("view_other");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".active-tab #view_other"), "Other");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".active-pane .criteria-group-actions"), "Global Post Functions");
    }
}

