/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueTransitionsMeta;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import io.atlassian.fugue.Iterables;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY, Category.REFERENCE_PLUGIN, Category.PERMISSIONS, Category.WORKFLOW})
@LoginAs(user="admin")
public class TestWorkflowTransitionPermission
extends BaseJiraFuncTest {
    private static final String TRANSITION_ISSUE_PERMISSION_OVERRIDE_MODULE = "com.atlassian.jira.dev.reference-plugin:brad.odlaw.cant.transition.issue";
    private static final String JIRA_USERS_GROUP = "jira-users";
    private static final long DEFAULT_PERMISSION_SCHEME_ID = 0L;
    private static final String PAUL_WITH_TRANSITION_POWER = "paul-with-transition-power";
    private static final String MARK_CANT_PERFORM_TRANSITION = "mark-cant-perform-transition";
    private static final String JIRA_DEVELOPERS_GROUP = "jira-developers";
    private static final int START_PROGRESS_TRANSITION_ID = 4;
    private static final String START_PROGRESS_TRANSITION_NAME = "Start Progress";
    private static final String BRAD = "brad_the_odlaw";
    private IssueCreateResponse testIssue;
    private IssueClient issueClient;

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.backdoor.restoreBlankInstance();
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.TRANSITION_ISSUES, JIRA_USERS_GROUP);
        this.backdoor.usersAndGroups().addUser(BRAD, BRAD, BRAD, "odlaw@atlassiqan.com").addUserToGroup(BRAD, JIRA_DEVELOPERS_GROUP);
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.TRANSITION_ISSUES, BRAD);
        this.backdoor.usersAndGroups().addUser(MARK_CANT_PERFORM_TRANSITION).addUserToGroup(MARK_CANT_PERFORM_TRANSITION, JIRA_DEVELOPERS_GROUP);
        this.backdoor.usersAndGroups().addUser(PAUL_WITH_TRANSITION_POWER).addUserToGroup(PAUL_WITH_TRANSITION_POWER, JIRA_DEVELOPERS_GROUP);
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.TRANSITION_ISSUES, PAUL_WITH_TRANSITION_POWER);
        this.testIssue = this.backdoor.issues().createIssue("HSP", "issue summary");
    }

    @Test
    public void testShouldNotBeAbleToPerformTransitionWhenTransitionPermissionIsVetoed() {
        this.initializeRestClient(BRAD);
        this.backdoor.plugins().disablePluginModule(TRANSITION_ISSUE_PERMISSION_OVERRIDE_MODULE);
        Iterable<IssueTransitionsMeta.Transition> issueTransitionsBeforeVeto = this.getIssueTransitions(this.testIssue.key());
        MatcherAssert.assertThat(issueTransitionsBeforeVeto, (Matcher)Matchers.not((Matcher)Matchers.emptyIterable()));
        this.backdoor.plugins().enablePluginModule(TRANSITION_ISSUE_PERMISSION_OVERRIDE_MODULE);
        MatcherAssert.assertThat(this.getIssueTransitions(this.testIssue.key()), (Matcher)Matchers.emptyIterable());
        IssueTransitionsMeta.Transition transition = (IssueTransitionsMeta.Transition)Iterables.first(issueTransitionsBeforeVeto).get();
        this.assertCannotExecuteTransitionViaRestClient(transition.id, transition.name);
    }

    @Test
    public void testShouldBeAbleToPerformTransitionWhenTransitionPermissionIsGranted() {
        this.navigation.login(PAUL_WITH_TRANSITION_POWER);
        this.navigation.issue().closeIssue(this.testIssue.key(), "Fixed", null);
        this.initializeRestClient(PAUL_WITH_TRANSITION_POWER);
        this.assertIssueStatusEquals(this.testIssue.key(), "Closed");
    }

    @Test
    public void testShouldNotBeAbleToPerformTransitionWhenTransitionPermissionIsRevokedUsingTransitionDialogWithComment() {
        this.navigation.login(MARK_CANT_PERFORM_TRANSITION);
        this.initializeRestClient(MARK_CANT_PERFORM_TRANSITION);
        Iterable<IssueTransitionsMeta.Transition> issueTransitions = this.getIssueTransitions(this.testIssue.key());
        MatcherAssert.assertThat(issueTransitions, (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testShouldNotBeAbleToPerformTransitionWhenTransitionPermissionIsRevokedUsingTransitionWithoutDialog() {
        this.navigation.login(MARK_CANT_PERFORM_TRANSITION);
        try {
            this.navigation.issue().performIssueActionWithoutDetailsDialog(this.testIssue.key(), START_PROGRESS_TRANSITION_NAME);
            Assert.fail((String)"Start progress should throw exception, did permission check failed?");
        }
        catch (AssertionError assertionError) {
            Assert.assertEquals((Object)"Link with text [Start Progress] not found in response.", (Object)((Throwable)((Object)assertionError)).getMessage());
        }
    }

    @Test
    public void testShouldNotSeeAnyTransitionsWhenTransitionPermissionIsRevoked() {
        this.navigation.login(MARK_CANT_PERFORM_TRANSITION);
        this.navigation.issue().assignIssue(this.testIssue.key(), null, MARK_CANT_PERFORM_TRANSITION);
        this.initializeRestClient(MARK_CANT_PERFORM_TRANSITION);
        Iterable<IssueTransitionsMeta.Transition> issueTransitions = this.getIssueTransitions(this.testIssue.key());
        MatcherAssert.assertThat(issueTransitions, (Matcher)Matchers.emptyIterable());
        this.assertCannotExecuteTransitionViaRestClient(4, START_PROGRESS_TRANSITION_NAME);
    }

    @Test
    public void testShouldBeAbleToStartProgressViaRestApiWhenTransitionPermissionIsGranted() {
        this.navigation.login(PAUL_WITH_TRANSITION_POWER);
        this.navigation.issue().assignIssue(this.testIssue.key(), null, PAUL_WITH_TRANSITION_POWER);
        this.initializeRestClient(PAUL_WITH_TRANSITION_POWER);
        Iterable<IssueTransitionsMeta.Transition> issueTransitions = this.getIssueTransitions(this.testIssue.key());
        MatcherAssert.assertThat(issueTransitions, (Matcher)Matchers.not((Matcher)Matchers.emptyIterable()));
        this.executeTransition(this.testIssue.key(), 4);
        this.assertIssueStatusEquals(this.testIssue.key(), "In Progress");
    }

    private void assertIssueStatusEquals(String issueKey, String expectedStatus) {
        String issueStatus = this.issueClient.get((String)issueKey, (Issue.Expand[])new Issue.Expand[0]).fields.status.name();
        Assert.assertEquals((Object)expectedStatus, (Object)issueStatus);
    }

    private void assertCannotExecuteTransitionViaRestClient(int transitionId, String transitionName) {
        ParsedResponse<?> resp = this.executeTransition(this.testIssue.key(), transitionId);
        Assert.assertEquals((String)"Status code should be 400", (long)400L, (long)resp.statusCode);
        String expectedMessage = "It seems that you have tried to perform a workflow operation (" + transitionName + ") that is not valid for the current state of this issue (" + this.testIssue.key() + "). The likely cause is that somebody has changed the issue recently, please look at the issue history for details.";
        MatcherAssert.assertThat((Object)resp.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{expectedMessage}));
    }

    private Iterable<IssueTransitionsMeta.Transition> getIssueTransitions(String issueKey) {
        Issue is = this.issueClient.get(issueKey, new Issue.Expand[]{Issue.Expand.transitions});
        return is.transitions;
    }

    private ParsedResponse<?> executeTransition(String issueKey, int transitionId) {
        IssueUpdateRequest request = new IssueUpdateRequest().fields(new IssueFields());
        request.transition(ResourceRef.withId((String)String.valueOf(transitionId)));
        return this.issueClient.transition(issueKey, request);
    }

    private void initializeRestClient(String user) {
        this.issueClient.loginAs(user);
    }
}

