/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.SearchRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import java.net.URI;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestWorkflowTransitionReindexing
extends BaseJiraFuncTest {
    @Inject
    private WorkflowUtil workflowUtil;

    @Test
    public void testReIndexingFieldsSetDuringTransition() throws Exception {
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
        this.backdoor.screens().addFieldToScreen("Resolve Issue Screen", "Log Work");
        this.backdoor.screens().addFieldToScreen("Resolve Issue Screen", "Summary");
        this.backdoor.screens().addFieldToScreen("Resolve Issue Screen", "Comment");
        JiraRestClient restClient = this.createRestClient();
        IssueRestClient issueClient = restClient.getIssueClient();
        IssueInput issueInput = new IssueInputBuilder("HSP", Long.valueOf(1L)).setSummary("new issue").setDescription("issue description").build();
        Issue issue = (Issue)issueClient.getIssue(((BasicIssue)issueClient.createIssue(issueInput).claim()).getKey()).claim();
        Iterable transitions = (Iterable)issueClient.getTransitions(issue).claim();
        Transition resolveIssue = StreamSupport.stream(transitions.spliterator(), false).filter(transition -> transition.getName().contains("Resolve")).findFirst().get();
        this.navigation.issue().gotoIssue(issue.getKey());
        this.workflowUtil.clickAction("action_id_" + resolveIssue.getId());
        this.tester.setWorkingForm("issue-workflow-transition");
        String changedSummaryValue = "changed summary";
        this.tester.setFormElement("comment", "some random comment");
        this.tester.setFormElement("worklog_timeLogged", "2h");
        this.tester.setFormElement("summary", changedSummaryValue);
        this.tester.submit();
        SearchRestClient searchClient = restClient.getSearchClient();
        SearchResult searchResult = (SearchResult)searchClient.searchJql("timespent > 1h").claim();
        Assert.assertThat((Object)searchResult.getIssues(), (Matcher)Matchers.contains(this.issue(issue.getKey())));
        searchResult = (SearchResult)searchClient.searchJql("summary ~ \"" + changedSummaryValue + "\"").claim();
        Assert.assertThat((Object)searchResult.getIssues(), (Matcher)Matchers.contains(this.issue(issue.getKey())));
        searchResult = (SearchResult)searchClient.searchJql("summary ~ issue").claim();
        Assert.assertThat((Object)searchResult.getIssues(), (Matcher)Matchers.emptyIterable());
        searchResult = (SearchResult)searchClient.searchJql("comment ~ random").claim();
        Assert.assertThat((Object)searchResult.getIssues(), (Matcher)Matchers.contains(this.issue(issue.getKey())));
    }

    private JiraRestClient createRestClient() {
        AsynchronousJiraRestClientFactory restClientFactory = new AsynchronousJiraRestClientFactory();
        try {
            URI baseUri = this.environmentData.getBaseUrl().toURI();
            return restClientFactory.createWithBasicHttpAuthentication(baseUri, "admin", "admin");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Matcher<Issue> issue(final String issueKey) {
        return new TypeSafeMatcher<Issue>(){

            protected boolean matchesSafely(Issue issue) {
                return issue.getKey().equals(issueKey);
            }

            public void describeTo(Description description) {
                description.appendText("Issue").appendValue((Object)issueKey).appendText("not on the list");
            }
        };
    }
}

