/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
public class TestWorkflowTransitionView
extends BaseJiraFuncTest {
    private static final String TRANSITION_NAME_1 = "My Transition 1";
    private static final String TRANSITION_NAME_2 = "My Transition 2";
    private static final String TRANSITION_DESC = "This is a test transition";
    private static final String TRANSITION_FIELD_SCREEN = "No view for transition";
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.administration.restoreBlankInstance();
    }

    private void copyWorkflowAndAddTransitions() {
        this.administration.workflows().goTo().copyWorkflow("jira", "Copied Workflow", "Workflow copied from JIRA default");
        this.tester.assertTextPresent("Copied Workflow");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").addTransition("Open", TRANSITION_NAME_1, TRANSITION_DESC, "Closed", TRANSITION_FIELD_SCREEN).addTransition("Open", TRANSITION_NAME_2, TRANSITION_DESC, "Closed", TRANSITION_FIELD_SCREEN);
    }

    @Test
    public void testTransitionView1() {
        this.copyWorkflowAndAddTransitions();
        this.administration.workflows().goTo().workflowSteps("Copied Workflow");
        this.tester.clickLinkWithText(TRANSITION_NAME_1);
        this.tester.assertTextPresent("None - it will happen instantly");
        this.tester.clickLink("edit_transition");
        this.tester.assertFormElementEquals("view", "");
        this.tester.submit("Update");
        this.tester.assertTextPresent("None - it will happen instantly");
        this.tester.clickLink("edit_transition");
        this.tester.assertFormElementEquals("view", "");
        this.tester.selectOption("view", "Default Screen");
        this.tester.assertFormElementEquals("view", "1");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Default Screen");
        this.tester.clickLink("edit_transition");
        this.tester.assertFormElementEquals("view", "1");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Default Screen");
        this.tester.clickLink("edit_transition");
        this.tester.assertFormElementEquals("view", "1");
        this.tester.selectOption("view", "Workflow Screen");
        this.tester.assertFormElementEquals("view", "2");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Workflow Screen");
        this.tester.clickLink("edit_transition");
        this.tester.assertFormElementEquals("view", "2");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Workflow Screen");
        this.tester.clickLink("edit_transition");
        this.tester.assertFormElementEquals("view", "2");
        this.tester.selectOption("view", TRANSITION_FIELD_SCREEN);
        this.tester.assertFormElementEquals("view", "");
        this.tester.submit("Update");
        this.tester.assertTextPresent("None - it will happen instantly");
        this.tester.clickLink("edit_transition");
        this.tester.assertFormElementEquals("view", "");
        this.tester.submit("Update");
        this.tester.assertTextPresent("None - it will happen instantly");
    }

    @Test
    public void testTransitionView2() {
        this.copyWorkflowAndAddTransitions();
        this.administration.workflows().goTo().workflowSteps("Copied Workflow");
        this.tester.clickLinkWithText(TRANSITION_NAME_2);
        this.tester.assertTextPresent("None - it will happen instantly");
        this.tester.clickLink("edit_transition");
        this.tester.assertFormElementEquals("view", "");
        this.tester.selectOption("destinationStep", "Closed");
        this.tester.assertFormElementEquals("view", "");
        this.tester.submit("Update");
        this.tester.assertTextPresent("None - it will happen instantly");
        this.tester.clickLink("edit_transition");
        this.tester.assertFormElementEquals("view", "");
        this.tester.selectOption("view", "Resolve Issue Screen");
        this.tester.assertFormElementEquals("view", "3");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Resolve Issue Screen");
        this.tester.clickLink("edit_transition");
        this.tester.assertFormElementEquals("view", "3");
        this.tester.selectOption("destinationStep", "Resolved");
        this.tester.assertFormElementEquals("view", "3");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Resolve Issue Screen");
        this.tester.clickLink("edit_transition");
        this.tester.assertFormElementEquals("view", "3");
        this.tester.selectOption("view", TRANSITION_FIELD_SCREEN);
        this.tester.assertFormElementEquals("view", "");
        this.tester.submit("Update");
        this.tester.assertTextPresent("None - it will happen instantly");
    }

    @Test
    public void shouldEscapeUsernameWhenNullIsAllowed() {
        this.shouldEscapeUsername("true");
    }

    private void shouldEscapeUsername(String nullAllowed) {
        int stepId = 1;
        int transitionId = 4;
        String username = "<script>alert(1)</script>";
        String permissionKey = "ADMINISTER_PROJECTS";
        this.addUserPermissionValidator(stepId, transitionId, username, permissionKey, nullAllowed);
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").editTransition(stepId, transitionId);
        this.tester.assertTextNotPresent(username);
        this.tester.assertTextPresent(TextUtils.htmlEncode((String)username));
    }

    private void addUserPermissionValidator(int stepId, int transitionId, String username, String permissionKey, String nullAllowed) {
        String workflowValidatorKey = "com.atlassian.jira.plugin.system.workflow:user-permission-validator";
        HashMap<String, String> configFormParams = new HashMap<String, String>();
        configFormParams.put("vars.key", username);
        configFormParams.put("permissionKey", permissionKey);
        configFormParams.put("nullallowed", nullAllowed);
        this.copyWorkflowAndAddTransitions();
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").editTransition(stepId, transitionId).addWorkflowValidator(workflowValidatorKey, configFormParams);
    }

    @Test
    public void shouldEscapeUsernameWhenNullIsForbidden() {
        this.shouldEscapeUsername("false");
    }
}

