/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.util.Supplier;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;

class DelegateSearcher
extends IndexSearcher
implements Supplier<IndexSearcher> {
    private final IndexSearcher searcher;

    DelegateSearcher(@NotNull IndexSearcher indexSearcher) {
        super(indexSearcher.getIndexReader());
        this.searcher = indexSearcher;
    }

    public IndexSearcher get() {
        return this.searcher;
    }

    public IndexReader getIndexReader() {
        return this.searcher.getIndexReader();
    }

    public void setQueryCache(QueryCache queryCache) {
        this.searcher.setQueryCache(queryCache);
    }

    public QueryCache getQueryCache() {
        return this.searcher.getQueryCache();
    }

    public void setQueryCachingPolicy(QueryCachingPolicy queryCachingPolicy) {
        this.searcher.setQueryCachingPolicy(queryCachingPolicy);
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.searcher.getQueryCachingPolicy();
    }

    protected IndexSearcher.LeafSlice[] slices(List<LeafReaderContext> leaves) {
        return super.slices(leaves);
    }

    public Weight createNormalizedWeight(Query query, boolean needsScores) throws IOException {
        return this.searcher.createNormalizedWeight(query, needsScores);
    }

    public Weight createWeight(Query query, boolean needsScores, float boost) throws IOException {
        return this.searcher.createWeight(query, needsScores, boost);
    }

    public IndexReaderContext getTopReaderContext() {
        return this.searcher.getTopReaderContext();
    }

    public TermStatistics termStatistics(Term term, TermContext context) throws IOException {
        return this.searcher.termStatistics(term, context);
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        return this.searcher.collectionStatistics(field);
    }

    public Document doc(int n, Set<String> fieldsToLoad) throws IOException {
        return this.searcher.doc(n, fieldsToLoad);
    }

    public void doc(int n, StoredFieldVisitor fieldVisitor) throws IOException {
        this.searcher.doc(n, fieldVisitor);
    }

    public Document doc(int i) throws IOException {
        return this.searcher.doc(i);
    }

    public boolean equals(Object obj) {
        return this.searcher.equals(obj);
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return this.searcher.explain(query, doc);
    }

    protected Explanation explain(Weight weight, int doc) throws IOException {
        return super.explain(weight, doc);
    }

    public Similarity getSimilarity(boolean needsScores) {
        return this.searcher.getSimilarity(needsScores);
    }

    public int hashCode() {
        return this.searcher.hashCode();
    }

    public Query rewrite(Query query) throws IOException {
        return this.searcher.rewrite(query);
    }

    public int count(Query query) throws IOException {
        return this.searcher.count(query);
    }

    public TopFieldDocs search(Query query, int n, Sort sort) throws IOException {
        return this.searcher.search(query, n, sort);
    }

    public TopDocs search(Query query, int n) throws IOException {
        return this.searcher.search(query, n);
    }

    public void search(Query query, Collector results) throws IOException {
        this.searcher.search(query, results);
    }

    public TopFieldDocs search(Query query, int n, Sort sort, boolean doDocScores, boolean doMaxScore) throws IOException {
        return this.searcher.search(query, n, sort, doDocScores, doMaxScore);
    }

    public <C extends Collector, T> T search(Query query, CollectorManager<C, T> collectorManager) throws IOException {
        return (T)this.searcher.search(query, collectorManager);
    }

    protected void search(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        super.search(leaves, weight, collector);
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, int numHits) throws IOException {
        return this.searcher.searchAfter(after, query, numHits);
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, int n, Sort sort) throws IOException {
        return this.searcher.searchAfter(after, query, n, sort);
    }

    public TopFieldDocs searchAfter(ScoreDoc after, Query query, int numHits, Sort sort, boolean doDocScores, boolean doMaxScore) throws IOException {
        return this.searcher.searchAfter(after, query, numHits, sort, doDocScores, doMaxScore);
    }

    public void setSimilarity(Similarity similarity) {
        this.searcher.setSimilarity(similarity);
    }

    public String toString() {
        return this.searcher.toString();
    }
}

