/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene.sort;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.search.parameters.lucene.sort.DefaultMatchHandler;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MappedSortComparator;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MatchHandler;
import com.atlassian.jira.issue.search.parameters.lucene.sort.SingleValueMatchHandler;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

public class JiraLuceneFieldFinder {
    private static final JiraLuceneFieldFinder FIELD_FINDER = new JiraLuceneFieldFinder();

    public static JiraLuceneFieldFinder getInstance() {
        return FIELD_FINDER;
    }

    public Object[] getCustom(IndexReader reader, String field, MappedSortComparator mappedSortComparator) throws IOException {
        Terms terms;
        Object[] retArray = new Object[reader.maxDoc()];
        if (retArray.length > 0 && (terms = MultiFields.getTerms((IndexReader)reader, (String)field)) != null) {
            TermsEnum termsEnum = terms.iterator();
            Comparator comparator = mappedSortComparator.getComparator();
            PostingsEnum postings = null;
            while (termsEnum.next() != null) {
                Object termval = mappedSortComparator.getComparable(termsEnum.term().utf8ToString());
                postings = termsEnum.postings(postings);
                while (postings.nextDoc() != Integer.MAX_VALUE) {
                    Object currentValue = retArray[postings.docID()];
                    if (currentValue != null && comparator.compare(termval, currentValue) >= 1) continue;
                    retArray[postings.docID()] = termval;
                }
            }
        }
        return retArray;
    }

    public List<String> getTermValuesForField(IndexReader reader, String field) throws IOException {
        Terms terms;
        ArrayList result = Lists.newArrayList();
        if (field != null && (terms = MultiFields.getTerms((IndexReader)reader, (String)field)) != null) {
            TermsEnum termsEnum = terms.iterator();
            while (termsEnum.next() != null) {
                BytesRef currTerm = termsEnum.term();
                result.add(currTerm.utf8ToString());
            }
        }
        return result;
    }

    public Collection<String>[] getMatches(IndexReader reader, String field) throws IOException {
        int maxDoc = reader.maxDoc();
        DefaultMatchHandler handler = new DefaultMatchHandler(maxDoc);
        this.getMatches(reader, field, handler);
        return handler.getResults();
    }

    @ExperimentalApi
    public List<String>[] getUniqueMatches(IndexReader reader, String field) throws IOException {
        int maxDoc = reader.maxDoc();
        SingleValueMatchHandler handler = new SingleValueMatchHandler(maxDoc);
        this.getMatches(reader, field, handler);
        return handler.getResults();
    }

    @ExperimentalApi
    public void getMatches(IndexReader reader, String field, MatchHandler handler) throws IOException {
        if (reader.maxDoc() == 0) {
            return;
        }
        PostingsEnum postings = null;
        Terms terms = MultiFields.getTerms((IndexReader)reader, (String)field);
        if (terms != null) {
            TermsEnum termsEnum = terms.iterator();
            while (termsEnum.next() != null) {
                BytesRef term = termsEnum.term();
                String termval = term.utf8ToString();
                postings = termsEnum.postings(postings);
                while (postings.nextDoc() != Integer.MAX_VALUE) {
                    handler.handleMatchedDocument(postings.docID(), termval);
                }
            }
        }
    }
}

