/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.comparator.util.DelegatingComparator;
import com.atlassian.jira.issue.search.parameters.lucene.JiraBytesRef;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.StatisticGatherer;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.BytesRefMapper;
import com.atlassian.jira.issue.statistics.util.CachingBytesRefMapper;
import com.atlassian.jira.issue.statistics.util.ComparatorSelector;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang3.ArrayUtils;

public class TwoDimensionalStatsMap {
    public static final String TOTAL_ORDER = "total";
    public static final String NATURAL_ORDER = "natural";
    public static final String DESC = "desc";
    public static final String ASC = "asc";
    private final java.util.function.Supplier<List<Object>> nullXValues;
    private final java.util.function.Supplier<List<Object>> nullYValues;
    private final BytesRefMapper xAxisBytesMapper;
    private final StatisticsMapper<Object> xAxisMapper;
    private final StatisticsMapper<Object> yAxisMapper;
    private final BytesRefMapper yAxisByteMapper;
    private final StatisticGatherer statisticGatherer;
    private final Map xAxis;
    private final Map xAxisTotals;
    private final Map yAxisTotals;
    private final Map<Object, Number> xAxisIrrelevantTotals;
    private int bothIrrelevant = 0;
    private final Map<Object, Number> yAxisIrrelevantTotals;
    private Number entireTotal;

    public TwoDimensionalStatsMap(StatisticsMapper xAxisMapper, StatisticsMapper yAxisMapper, StatisticGatherer statisticGatherer) {
        Comparator xAxisComparator = ComparatorSelector.getComparator(xAxisMapper);
        Comparator yAxisComparator = ComparatorSelector.getComparator(yAxisMapper);
        this.xAxisBytesMapper = new CachingBytesRefMapper(xAxisMapper);
        this.xAxisMapper = xAxisMapper;
        this.yAxisByteMapper = new CachingBytesRefMapper(yAxisMapper);
        this.yAxisMapper = yAxisMapper;
        this.statisticGatherer = statisticGatherer;
        this.xAxis = new TreeMap(new IrrelevantHandlingComparator(xAxisComparator));
        this.xAxisTotals = new TreeMap(new IrrelevantHandlingComparator(xAxisComparator));
        this.yAxisTotals = new TreeMap(new IrrelevantHandlingComparator(yAxisComparator));
        this.xAxisIrrelevantTotals = new TreeMap(yAxisComparator);
        this.yAxisIrrelevantTotals = new TreeMap(xAxisComparator);
        this.nullXValues = () -> ((Supplier)Suppliers.memoize(() -> TwoDimensionalStatsMap.transformAndRemoveInvalid(new JiraBytesRef[]{null}, this.xAxisBytesMapper, arg_0 -> this.xAxisMapper.isValidValue(arg_0)))).get();
        this.nullYValues = () -> ((Supplier)Suppliers.memoize(() -> TwoDimensionalStatsMap.transformAndRemoveInvalid(new JiraBytesRef[]{null}, this.yAxisByteMapper, arg_0 -> this.yAxisMapper.isValidValue(arg_0)))).get();
    }

    public TwoDimensionalStatsMap(StatisticsMapper xAxisMapper, StatisticsMapper yAxisMapper) {
        this(xAxisMapper, yAxisMapper, (StatisticGatherer)new StatisticGatherer.Sum());
    }

    private void addToXTotal(Object xValue, int i) {
        Number total = (Number)this.xAxisTotals.get(xValue);
        this.xAxisTotals.put(xValue, this.statisticGatherer.getValue(total, i));
    }

    private void addToYTotal(Object yValue, int i) {
        Number total = (Number)this.yAxisTotals.get(yValue);
        this.yAxisTotals.put(yValue, this.statisticGatherer.getValue(total, i));
    }

    private void addToEntireTotal(int i) {
        this.entireTotal = this.statisticGatherer.getValue(this.entireTotal, i);
    }

    void addValue(Object xValue, Object yValue, int i) {
        TreeMap<Object, Number> yValues = (TreeMap<Object, Number>)this.xAxis.get(xValue);
        if (yValues == null) {
            yValues = new TreeMap<Object, Number>(ComparatorSelector.getComparator(this.yAxisMapper));
            this.xAxis.put(xValue, yValues);
        }
        Number existingValue = (Number)yValues.get(yValue);
        yValues.put(yValue, this.statisticGatherer.getValue(existingValue, i));
    }

    void addToYIrrelevantTotals(Collection xValues, int incrementValue) {
        for (Object xValue : xValues) {
            Number existingValue = this.yAxisIrrelevantTotals.get(xValue);
            this.yAxisIrrelevantTotals.put(xValue, this.statisticGatherer.getValue(existingValue, incrementValue));
        }
    }

    void addToXIrrelevantTotals(Collection yValues, int incrementValue) {
        for (Object yValue : yValues) {
            Number existingValue = this.xAxisIrrelevantTotals.get(yValue);
            this.xAxisIrrelevantTotals.put(yValue, this.statisticGatherer.getValue(existingValue, incrementValue));
        }
    }

    public Collection getXAxis() {
        TreeSet<Object> xVals = new TreeSet<Object>(ComparatorSelector.getComparator(this.xAxisMapper));
        if (this.xAxis.keySet() != null) {
            xVals.addAll(this.xAxis.keySet());
        }
        if (this.yAxisIrrelevantTotals.keySet() != null) {
            xVals.addAll(this.yAxisIrrelevantTotals.keySet());
        }
        return xVals;
    }

    public Collection getYAxis() {
        return this.getYAxis(NATURAL_ORDER, ASC);
    }

    public Collection getYAxis(String orderBy, String direction) {
        Comparator comp;
        if (orderBy != null && orderBy.equals(TOTAL_ORDER)) {
            comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    Long o1Long = new Long(TwoDimensionalStatsMap.this.getYAxisUniqueTotal(o1));
                    Long o2Long = new Long(TwoDimensionalStatsMap.this.getYAxisUniqueTotal(o2));
                    return o1Long.compareTo(o2Long);
                }
            };
            if (direction != null && direction.equals(DESC)) {
                comp = new ReverseComparator(comp);
            }
            comp = new DelegatingComparator(comp, ComparatorSelector.getComparator(this.yAxisMapper));
        } else {
            comp = ComparatorSelector.getComparator(this.yAxisMapper);
            if (direction != null && direction.equals(DESC)) {
                comp = new ReverseComparator(comp);
            }
        }
        return this.getYAxis(comp);
    }

    public Collection getYAxis(Comparator comp) {
        TreeSet<Object> yAxisKeys = new TreeSet<Object>(comp);
        for (Object o : this.xAxis.values()) {
            Map yAxisValues = (Map)o;
            yAxisKeys.addAll(yAxisValues.keySet());
        }
        if (this.xAxisIrrelevantTotals.keySet() != null) {
            yAxisKeys.addAll(this.xAxisIrrelevantTotals.keySet());
        }
        return yAxisKeys;
    }

    public int getCoordinate(Object xAxis, Object yAxis) {
        Map yValues = (Map)this.xAxis.get(xAxis);
        if (yValues == null) {
            return 0;
        }
        Number value = (Number)yValues.get(yAxis);
        return value == null ? 0 : value.intValue();
    }

    public StatisticsMapper getyAxisMapper() {
        return this.yAxisMapper;
    }

    public StatisticsMapper getxAxisMapper() {
        return this.xAxisMapper;
    }

    public int getXAxisUniqueTotal(Object xAxis) {
        Number xTotal = (Number)this.xAxisTotals.get(xAxis);
        return xTotal != null ? xTotal.intValue() : 0;
    }

    public int getYAxisUniqueTotal(Object yAxis) {
        Number yTotal = (Number)this.yAxisTotals.get(yAxis);
        return yTotal != null ? yTotal.intValue() : 0;
    }

    public int getXAxisIrrelevantTotal(Object yAxis) {
        Number xTotal = this.xAxisIrrelevantTotals.get(yAxis);
        return xTotal != null ? xTotal.intValue() : 0;
    }

    public int getYAxisIrrelevantTotal(Object xAxis) {
        Number yTotal = this.yAxisIrrelevantTotals.get(xAxis);
        return yTotal != null ? yTotal.intValue() : 0;
    }

    public int getBothIrrelevant() {
        return this.bothIrrelevant;
    }

    public boolean hasIrrelevantXData() {
        if (this.bothIrrelevant > 0) {
            return true;
        }
        for (Number xAxisIrrelevantTotal : this.xAxisIrrelevantTotals.values()) {
            if (xAxisIrrelevantTotal == null || xAxisIrrelevantTotal.intValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasIrrelevantYData() {
        if (this.bothIrrelevant > 0) {
            return true;
        }
        for (Number yAxisIrrelevantTotal : this.yAxisIrrelevantTotals.values()) {
            if (yAxisIrrelevantTotal == null || yAxisIrrelevantTotal.intValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public long getUniqueTotal() {
        return this.entireTotal != null ? (long)this.entireTotal.intValue() : 0L;
    }

    public void adjustMapForIrrelevantValues(JiraBytesRef[] xAxisValues, boolean xIrrelevant, JiraBytesRef[] yAxisValues, boolean yIrrelevant, int incrementValue) {
        if (xIrrelevant && yIrrelevant) {
            ++this.bothIrrelevant;
        } else if (xIrrelevant) {
            this.addToXTotal(FilterStatisticsValuesGenerator.IRRELEVANT, incrementValue);
            List<Object> transformedYValues = ArrayUtils.isEmpty((Object[])yAxisValues) ? (List<Object>)this.nullYValues.get() : TwoDimensionalStatsMap.transformAndRemoveInvalid(yAxisValues, this.yAxisByteMapper, arg_0 -> this.yAxisMapper.isValidValue(arg_0));
            this.addToXIrrelevantTotals(transformedYValues, incrementValue);
        } else if (yIrrelevant && !xIrrelevant) {
            this.addToYTotal(FilterStatisticsValuesGenerator.IRRELEVANT, incrementValue);
            List<Object> transformedXValues = ArrayUtils.isEmpty((Object[])xAxisValues) ? (List<Object>)this.nullXValues.get() : TwoDimensionalStatsMap.transformAndRemoveInvalid(xAxisValues, this.xAxisBytesMapper, arg_0 -> this.xAxisMapper.isValidValue(arg_0));
            this.addToYIrrelevantTotals(transformedXValues, incrementValue);
        }
        this.addToEntireTotal(1);
    }

    public void adjustMapForValues(JiraBytesRef[] xAxisValues, JiraBytesRef[] yAxisValues, int value) {
        List<Object> transformedXValues = ArrayUtils.isEmpty((Object[])xAxisValues) ? (List<Object>)this.nullXValues.get() : TwoDimensionalStatsMap.transformAndRemoveInvalid(xAxisValues, this.xAxisBytesMapper, arg_0 -> this.xAxisMapper.isValidValue(arg_0));
        List<Object> transformedYValues = ArrayUtils.isEmpty((Object[])yAxisValues) ? (List<Object>)this.nullYValues.get() : TwoDimensionalStatsMap.transformAndRemoveInvalid(yAxisValues, this.yAxisByteMapper, arg_0 -> this.yAxisMapper.isValidValue(arg_0));
        for (Object e : transformedXValues) {
            this.addToXTotal(e, value);
            for (Object e2 : transformedYValues) {
                this.addValue(e, e2, value);
            }
        }
        for (Object e : transformedYValues) {
            this.addToYTotal(e, value);
        }
        this.addToEntireTotal(value);
    }

    private static List<Object> transformAndRemoveInvalid(JiraBytesRef[] values, BytesRefMapper mapper, Predicate<Object> validator) {
        ArrayList output = Lists.newArrayListWithCapacity((int)values.length);
        for (JiraBytesRef value : values) {
            Object transformedValue = value != null ? (Object)mapper.mapValue(value) : null;
            if (!validator.test(transformedValue)) continue;
            output.add(transformedValue);
        }
        return output;
    }

    private static class IrrelevantHandlingComparator
    implements Comparator {
        private final Comparator delegate;

        public IrrelevantHandlingComparator(Comparator delegate) {
            this.delegate = delegate;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == FilterStatisticsValuesGenerator.IRRELEVANT) {
                return -1;
            }
            if (o2 == FilterStatisticsValuesGenerator.IRRELEVANT) {
                return 1;
            }
            return this.delegate.compare(o1, o2);
        }
    }
}

