/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.components;

import com.atlassian.jira.pageobjects.components.fields.SingleSelect;
import com.atlassian.jira.pageobjects.form.FormUtils;
import com.atlassian.jira.pageobjects.pages.AbstractJiraPage;
import com.atlassian.jira.projects.pageobjects.webdriver.page.ComponentsPage;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import org.openqa.selenium.By;

public class ComponentEditPage
extends AbstractJiraPage {
    @Inject
    PageBinder binder;
    @ElementBy(id="component-edit")
    PageElement form;
    @ElementBy(id="component-name")
    PageElement name;
    @ElementBy(id="component-description")
    PageElement description;
    @ElementBy(id="component-save-submit")
    PageElement save;
    @ElementBy(cssSelector="div.aui-message-success")
    PageElement divSuccessMessage;
    @ElementBy(cssSelector="div.aui-message.error")
    PageElement divGlobalError;
    @ElementBy(cssSelector="div.error")
    PageElement divError;
    private final Long componentId;
    private String projectKey;

    public ComponentEditPage(Long componentId, String projectKey) {
        this.componentId = componentId;
        this.projectKey = projectKey;
    }

    public TimedCondition isAt() {
        return this.save.timed().isVisible();
    }

    public String getUrl() {
        return "/secure/ComponentEdit!default.jspa?componentId=" + this.componentId;
    }

    public ComponentEditPage save() {
        this.save.click();
        return (ComponentEditPage)((Object)this.pageBinder.bind(ComponentEditPage.class, new Object[]{this.componentId, this.projectKey}));
    }

    public ComponentsPage saveDialog() {
        this.save.click();
        Poller.waitUntilFalse((String)"Form was removed from", (TimedQuery)this.form.timed().isPresent());
        return (ComponentsPage)((Object)this.pageBinder.bind(ComponentsPage.class, new Object[]{this.projectKey}));
    }

    public SingleSelect getComponentLead() {
        return (SingleSelect)this.binder.bind(SingleSelect.class, new Object[]{this.form.find(By.id((String)"component-lead-container"))});
    }

    public SingleSelect getAssigneeType() {
        return (SingleSelect)this.binder.bind(SingleSelect.class, new Object[]{this.form.find(By.id((String)"assignee-type-container"))});
    }

    public String getName() {
        return this.name.getValue();
    }

    public String getDescription() {
        return this.description.getValue();
    }

    public Map<String, String> getFormErrors() {
        return FormUtils.getAuiFormErrors((PageElement)this.form);
    }

    public Collection<String> getGlobalErrors() {
        return FormUtils.getAuiFormGlobalErrors((PageElement)this.form);
    }

    public ComponentEditPage typeName(String text) {
        this.name.clear();
        this.name.type(new CharSequence[]{text});
        return this;
    }

    public ComponentEditPage typeDescription(String text) {
        this.description.clear();
        this.description.type(new CharSequence[]{text});
        return this;
    }

    public TimedCondition hasSuccessMessage() {
        return this.divSuccessMessage.timed().isPresent();
    }

    public TimedCondition hasGlobalError() {
        return this.divGlobalError.timed().isPresent();
    }

    public TimedCondition hasError() {
        return this.divError.timed().isPresent();
    }
}

