/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.filter;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DenyAccessForUnauthenticatedUsersFilter
extends AbstractHttpFilter {
    private final JiraAuthenticationContext authenticationContext;
    private final FeatureManager featureManager;

    public DenyAccessForUnauthenticatedUsersFilter(JiraAuthenticationContext authenticationContext, FeatureManager featureManager) {
        this.authenticationContext = authenticationContext;
        this.featureManager = featureManager;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.DISABLE_ANONYMOUS_ACCESS_TO_MENU_ENDPOINTS) && !this.authenticationContext.isLoggedInUser()) {
            response.sendError(401);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

