/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.jql;

import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ValueGeneratingClauseHandler;
import com.atlassian.jira.jql.operand.registry.PredicateRegistry;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.DelimeterInserter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;

public class FieldAndPredicateAutoCompleteResultGenerator {
    public static final int MAX_RESULTS = 15;
    private final JiraAuthenticationContext authenticationContext;
    private final JqlStringSupport jqlStringSupport;
    private final SearchHandlerManager searchHandlerManager;
    private final PredicateRegistry predicateRegistry;

    public FieldAndPredicateAutoCompleteResultGenerator(JiraAuthenticationContext authenticationContext, JqlStringSupport jqlStringSupport, SearchHandlerManager searchHandlerManager, PredicateRegistry predicateRegistry) {
        this.authenticationContext = authenticationContext;
        this.jqlStringSupport = jqlStringSupport;
        this.searchHandlerManager = searchHandlerManager;
        this.predicateRegistry = predicateRegistry;
    }

    public Iterable<Result> getAutoCompleteResultsForField(String fieldName, String fieldValue) {
        ClauseHandler clauseHandler;
        Preconditions.checkNotNull((Object)fieldName);
        Preconditions.checkNotNull((Object)fieldValue);
        ApplicationUser searcher = this.getSearcher();
        Collection clauseHandlers = this.searchHandlerManager.getClauseHandler(searcher, fieldName);
        if (clauseHandlers.size() == 1 && (clauseHandler = (ClauseHandler)clauseHandlers.iterator().next()) instanceof ValueGeneratingClauseHandler) {
            ClauseValuesGenerator clauseValuesGenerator = ((ValueGeneratingClauseHandler)clauseHandler).getClauseValuesGenerator();
            return this.generateResults(clauseValuesGenerator, searcher, fieldName, fieldValue);
        }
        return ImmutableList.of();
    }

    public Iterable<Result> getAutoCompleteResultsForPredicate(String predicateName, String predicateValue, String fieldName) {
        Preconditions.checkNotNull((Object)fieldName);
        Preconditions.checkNotNull((Object)predicateName);
        Preconditions.checkNotNull((Object)predicateValue);
        ApplicationUser searcher = this.getSearcher();
        ClauseValuesGenerator clauseValuesGenerator = this.predicateRegistry.getClauseValuesGenerator(predicateName, fieldName);
        if (clauseValuesGenerator != null) {
            return this.generateResults(clauseValuesGenerator, searcher, predicateName, predicateValue);
        }
        return ImmutableList.of();
    }

    private ApplicationUser getSearcher() {
        return this.authenticationContext.getUser();
    }

    private Iterable<Result> generateResults(ClauseValuesGenerator clauseValuesGenerator, ApplicationUser searcher, String fieldName, String fieldValue) {
        DelimeterInserter delimeterInserter = new DelimeterInserter("<b>", "</b>");
        delimeterInserter.setConsideredWhitespace("-_/\\,.+=&^%$#*@!~`'\":;<>(");
        ClauseValuesGenerator.Results generatorResults = clauseValuesGenerator.getPossibleValues(searcher, fieldName, fieldValue, 15);
        List list = generatorResults.getResults();
        ImmutableList.Builder results = ImmutableList.builder();
        for (ClauseValuesGenerator.Result result : list) {
            StringBuilder displayName = new StringBuilder();
            for (int i = 0; i < result.getDisplayNameParts().length; ++i) {
                if (i != 0) {
                    displayName.append(" ");
                }
                String displayNamePart = result.getDisplayNameParts()[i];
                displayName.append(delimeterInserter.insert(TextUtils.htmlEncode((String)displayNamePart), new String[]{TextUtils.htmlEncode((String)fieldValue)}));
            }
            String encodedValue = this.jqlStringSupport.encodeValue(result.getValue());
            results.add((Object)new Result(this.quoteZeroPaddedNumbers(encodedValue), displayName.toString()));
        }
        return results.build();
    }

    private String quoteZeroPaddedNumbers(String value) {
        if (value == null) {
            return value;
        }
        try {
            long longVal = Long.parseLong(value);
            if (value.startsWith("0")) {
                return "\"" + value + "\"";
            }
            return value;
        }
        catch (NumberFormatException nfe) {
            return value;
        }
    }

    public static final class Result {
        private final String value;
        private final String displayName;

        public Result(String value, String displayName) {
            this.value = value;
            this.displayName = displayName;
        }

        public String getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

