/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v1;

import com.atlassian.classloader.TomcatResourceEntriesCacheFlusher;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Path(value="cache")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CacheResource {
    public static final Logger log = LoggerFactory.getLogger(CacheResource.class);
    private final EventPublisher eventPublisher;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final FeatureManager featureManager;

    @Inject
    public CacheResource(EventPublisher eventPublisher, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, FeatureManager featureManager) {
        this.eventPublisher = eventPublisher;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.featureManager = featureManager;
    }

    @Consumes(value={"*/*"})
    @DELETE
    @Path(value="app")
    public Response clearCaches() {
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.CACHE_RESOURCE)) {
            if (!this.permissionManager.hasPermission(44, this.jiraAuthenticationContext.getUser())) {
                throw new NotAuthorisedWebException();
            }
            this.eventPublisher.publish((Object)ClearCacheEvent.INSTANCE);
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        log.warn("CacheResource is disabled by default since 9.6, set com.atlassian.jira.cacheResource.enabled dark feature to use this endpoint. See https://confluence.atlassian.com/jirakb/how-to-manage-dark-features-in-jira-959286331.html for more details.");
        return Response.status((Response.Status)Response.Status.GONE).entity((Object)"CacheResource is disabled by default since 9.6, set com.atlassian.jira.cacheResource.enabled dark feature to use this endpoint. See https://confluence.atlassian.com/jirakb/how-to-manage-dark-features-in-jira-959286331.html for more details.").build();
    }

    @Consumes(value={"*/*"})
    @DELETE
    @Path(value="classloader")
    public Response clearClassLoaderCache() {
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.CACHE_RESOURCE)) {
            if (!this.permissionManager.hasPermission(44, this.jiraAuthenticationContext.getUser())) {
                throw new NotAuthorisedWebException();
            }
            new TomcatResourceEntriesCacheFlusher().run();
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        log.warn("CacheResource is disabled by default since 9.6, set com.atlassian.jira.cacheResource.enabled dark feature to use this endpoint. See https://confluence.atlassian.com/jirakb/how-to-manage-dark-features-in-jira-959286331.html for more details.");
        return Response.status((Response.Status)Response.Status.GONE).entity((Object)"CacheResource is disabled by default since 9.6, set com.atlassian.jira.cacheResource.enabled dark feature to use this endpoint. See https://confluence.atlassian.com/jirakb/how-to-manage-dark-features-in-jira-959286331.html for more details.").build();
    }
}

