/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.serializer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.PriorityJsonBean;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValueSerializer
extends JsonSerializer<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultValueSerializer.class);
    private final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE).setAnnotationIntrospector(DefaultValueSerializer.createJaxbJacksonAnnotationIntrospector());

    public DefaultValueSerializer() {
        this.mapper.registerModule((Module)new DefaultValueModule());
    }

    private static AnnotationIntrospector createJaxbJacksonAnnotationIntrospector() {
        JaxbAnnotationIntrospector jaxbIntrospector = new JaxbAnnotationIntrospector(TypeFactory.defaultInstance());
        JacksonAnnotationIntrospector jacksonIntrospector = new JacksonAnnotationIntrospector();
        return AnnotationIntrospector.pair((AnnotationIntrospector)jacksonIntrospector, (AnnotationIntrospector)jaxbIntrospector);
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value == null) {
            jgen.writeNull();
            return;
        }
        try {
            String json = this.mapper.writeValueAsString(value);
            if (StringUtils.isNotBlank((CharSequence)json)) {
                jgen.writeRaw(":" + json);
            } else {
                jgen.writeNull();
            }
        }
        catch (Exception e) {
            LOG.error("Cannot serialize value: " + value, (Throwable)e);
            jgen.writeNull();
        }
    }

    private static class DefaultValueModule
    extends SimpleModule {
        private Optional<JiraBaseUrls> jiraBaseUrls = Optional.empty();

        public DefaultValueModule() {
            super("Default value ", new Version(1, 0, 0, null));
            this.addSerializers();
        }

        private void addSerializers() {
            this.addSerializer(ApplicationUser.class, (JsonSerializer)new JsonSerializer<ApplicationUser>(){

                public void serialize(ApplicationUser value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    if (this.getJiraBaseUrls().isPresent()) {
                        jgen.writeObject((Object)UserBeanBuilder.shortBuilder((JiraBaseUrls)this.getJiraBaseUrls().get()).user(value).buildShort());
                    }
                }
            });
            this.addSerializer(Priority.class, (JsonSerializer)new JsonSerializer<Priority>(){

                public void serialize(Priority value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    if (this.getJiraBaseUrls().isPresent()) {
                        jgen.writeObject((Object)PriorityJsonBean.shortBean((Priority)value, (JiraBaseUrls)((JiraBaseUrls)this.getJiraBaseUrls().get())));
                    }
                }
            });
            this.addSerializer(Label.class, (JsonSerializer)new JsonSerializer<Label>(){

                public void serialize(Label value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    if (StringUtils.isNotBlank((CharSequence)value.getLabel())) {
                        jgen.writeString(value.getLabel());
                    }
                }
            });
            this.addSerializer(Date.class, (JsonSerializer)new JsonSerializer<Date>(){

                public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    jgen.writeString(Dates.asTimeString((Date)value));
                }
            });
            this.addSerializer(Timestamp.class, (JsonSerializer)new JsonSerializer<Timestamp>(){

                public void serialize(Timestamp value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    jgen.writeString(Dates.asTimeString((Timestamp)value));
                }
            });
        }

        private Optional<JiraBaseUrls> getJiraBaseUrls() {
            if (!this.jiraBaseUrls.isPresent()) {
                this.jiraBaseUrls = ComponentAccessor.getComponentSafely(JiraBaseUrls.class);
            }
            return this.jiraBaseUrls;
        }
    }
}

