/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.IssueFinderV2;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.stereotype.Component;

@Component
public class RestIssueFinder {
    private final IssueFinderV2 issueFinder;
    private final JiraAuthenticationContext authContext;

    public RestIssueFinder(@ComponentImport IssueFinderV2 issueFinder, JiraAuthenticationContext authContext) {
        this.issueFinder = issueFinder;
        this.authContext = authContext;
    }

    public Issue find(String issueIdOrKey) throws RESTException {
        Either either = this.issueFinder.findIssue(issueIdOrKey);
        if (either.isRight()) {
            return (Issue)either.getOrThrow(() -> new IllegalStateException("Issue should be present."));
        }
        ErrorCollection errors = (ErrorCollection)either.swap().map(this::mapErrors).getOrThrow(() -> new IllegalStateException("Errors should be present"));
        throw new RESTException(errors);
    }

    private ErrorCollection mapErrors(IssueFinderV2.SearchResult result) {
        I18nHelper translations = this.authContext.getI18nHelper();
        switch (result) {
            case INCORRECT_PARAM: {
                return ErrorCollection.of(translations.getText("rest.issue.key.or.id.required"));
            }
            case ISSUE_DOES_NOT_EXIST: {
                if (this.authContext.isLoggedInUser()) {
                    return new ErrorCollection().addErrorMessage(translations.getText("issue.does.not.exist.title")).reason(ErrorCollection.Reason.NOT_FOUND);
                }
            }
            case USER_HAS_NO_ACCESS: {
                ErrorCollection errors = new ErrorCollection();
                errors.addErrorMessage(translations.getText("admin.errors.issues.no.permission.to.see"));
                if (this.authContext.isLoggedInUser()) {
                    errors.reason(ErrorCollection.Reason.FORBIDDEN);
                } else {
                    errors.addErrorMessage(translations.getText("login.required.title")).reason(ErrorCollection.Reason.NOT_LOGGED_IN);
                }
                return errors;
            }
        }
        throw new IllegalStateException("Unhandled SearchResult: " + result);
    }
}

