/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util.serializers;

import com.atlassian.jira.rest.Dates;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.joda.time.DateTime;

@Provider
@ParamConverter.Lazy
public class JodaDateTimeParameterConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.getName().equals(DateTime.class.getName())) {
            return new ParamConverter<T>(){

                public T fromString(String dateStr) {
                    DateTime parsedDateTime = dateStr == null ? null : Dates.ISO_DATE_TIME_PARSER.parseDateTime(dateStr);
                    return parsedDateTime;
                }

                public String toString(T value) {
                    if (value == null) {
                        return null;
                    }
                    return value.toString();
                }
            };
        }
        return null;
    }
}

