/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.users;

import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarsDisabledException;
import com.atlassian.jira.avatar.NoPermissionException;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import com.atlassian.plugins.rest.api.security.exception.XsrfCheckFailedException;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="user")
@Produces(value={"application/json", "application/xml"})
@CorsAllowed
public class UserResource {
    private final JiraAuthenticationContext authenticationContext;
    private final AvatarService avatarService;
    private final XsrfInvocationChecker xsrfChecker;

    @Inject
    public UserResource(JiraAuthenticationContext authenticationContext, AvatarService avatarService, XsrfInvocationChecker xsrfChecker) {
        this.authenticationContext = authenticationContext;
        this.avatarService = avatarService;
        this.xsrfChecker = xsrfChecker;
    }

    @POST
    @Path(value="{username}/avatar/{avatarid}")
    public Response updateUserAvatar(@PathParam(value="username") String username, @PathParam(value="avatarid") Long avatarId) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        if (StringUtils.isBlank((CharSequence)username) || avatarId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"username and avatarid are required path parameters!").cacheControl(CacheControl.NO_CACHE).build();
        }
        try {
            this.avatarService.setCustomUserAvatar(this.authenticationContext.getUser(), username, avatarId);
            return Response.ok().cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (AvatarsDisabledException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (NoPermissionException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
    }
}

