/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin;

import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.admin.ConfigurationBean;
import com.atlassian.jira.rest.v2.admin.ConfigurationBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="configuration")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ConfigurationResource {
    private final JiraAuthenticationContext authenticationContext;
    private final ConfigurationBeanFactory configurationBeanFactory;
    private final ResponseFactory responseFactory;

    @Inject
    public ConfigurationResource(JiraAuthenticationContext authenticationContext, ConfigurationBeanFactory configurationBeanFactory, ResponseFactory responseFactory) {
        this.authenticationContext = authenticationContext;
        this.configurationBeanFactory = configurationBeanFactory;
        this.responseFactory = responseFactory;
    }

    @GET
    public Response getConfiguration() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        ConfigurationBean configurationBean = this.configurationBeanFactory.createConfigurationBean();
        return Response.status((Response.Status)Response.Status.OK).cacheControl(CacheControl.never()).entity((Object)configurationBean).build();
    }
}

