/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditRecord;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.ChangedValueImpl;
import com.atlassian.jira.rest.util.serializers.ISODateSerializer;
import com.atlassian.jira.rest.v2.admin.auditing.AssociatedItemBean;
import com.atlassian.jira.rest.v2.admin.auditing.ChangedValueBean;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@Deprecated
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class AuditRecordBean {
    private Long id;
    private String summary;
    private String remoteAddress;
    private String authorKey;
    private DateTime created;
    private String category;
    private String eventSource;
    private String description;
    private AssociatedItemBean objectItem;
    private List<ChangedValueBean> changedValues;
    private List<AssociatedItemBean> associatedItems;
    public static final AuditRecordBean DOC_EXAMPLE;
    public static final AuditRecordBean POST_EXAMPLE;

    public AuditRecordBean() {
    }

    public AuditRecordBean(AuditRecord auditRecord, String categoryName) {
        this.id = auditRecord.getId();
        this.summary = auditRecord.getSummary();
        this.remoteAddress = auditRecord.getRemoteAddr();
        this.authorKey = auditRecord.getAuthorKey();
        this.created = new DateTime((Object)auditRecord.getCreated());
        this.category = categoryName;
        this.eventSource = auditRecord.getEventSource();
        this.description = auditRecord.getDescription();
        this.objectItem = auditRecord.getObjectItem() != null ? new AssociatedItemBean(auditRecord.getObjectItem()) : null;
        this.changedValues = this.getChangedValues(auditRecord.getValues());
        this.associatedItems = this.getAssociatedItems(auditRecord.getAssociatedItems());
    }

    public Long getId() {
        return this.id;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getAuthorKey() {
        return this.authorKey;
    }

    @JsonSerialize(using=ISODateSerializer.class)
    public DateTime getCreated() {
        return this.created;
    }

    public AssociatedItemBean getObjectItem() {
        return this.objectItem;
    }

    public String getCategory() {
        return this.category;
    }

    public Iterable<AssociatedItemBean> getAssociatedItems() {
        return this.associatedItems;
    }

    public Iterable<ChangedValueBean> getChangedValues() {
        return this.changedValues;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public String getDescription() {
        return this.description;
    }

    private List<AssociatedItemBean> getAssociatedItems(Iterable<AssociatedItem> associatedItems) {
        Iterable itemBeans = Iterables.transform(associatedItems, (Function)new Function<AssociatedItem, AssociatedItemBean>(){

            public AssociatedItemBean apply(AssociatedItem item) {
                return new AssociatedItemBean(item);
            }
        });
        return !Iterables.isEmpty((Iterable)itemBeans) ? ImmutableList.copyOf((Iterable)itemBeans) : null;
    }

    private List<ChangedValueBean> getChangedValues(Iterable<ChangedValue> values) {
        Iterable valueBeans = Iterables.transform(values, (Function)new Function<ChangedValue, ChangedValueBean>(){

            public ChangedValueBean apply(ChangedValue value) {
                return new ChangedValueBean(value);
            }
        });
        return !Iterables.isEmpty((Iterable)valueBeans) ? ImmutableList.copyOf((Iterable)valueBeans) : null;
    }

    static {
        AuditRecord auditRecord = new AuditRecord(){

            @Nonnull
            public Long getId() {
                return 1L;
            }

            @Nonnull
            public Date getCreated() {
                return new Date(1395254742967L);
            }

            @Nonnull
            public AuditingCategory getCategory() {
                return AuditingCategory.USER_MANAGEMENT;
            }

            @Nonnull
            public String getSummary() {
                return "User created";
            }

            @Nonnull
            public String getEventSource() {
                return "Jira Connect Plugin";
            }

            @Nullable
            public String getDescription() {
                return "Optional description";
            }

            @Nullable
            public String getRemoteAddr() {
                return "192.168.1.1";
            }

            @Nullable
            public String getAuthorKey() {
                return "administrator";
            }

            @Nonnull
            public Iterable<AssociatedItem> getAssociatedItems() {
                return ImmutableList.of((Object)new AssociatedItem(){

                    @Nonnull
                    public String getObjectName() {
                        return "jira-software-users";
                    }

                    @Nullable
                    public String getObjectId() {
                        return "jira-software-users";
                    }

                    @Nullable
                    public String getParentName() {
                        return "Jira Internal Directory";
                    }

                    @Nullable
                    public String getParentId() {
                        return "1";
                    }

                    @Nonnull
                    public AssociatedItem.Type getObjectType() {
                        return AssociatedItem.Type.GROUP;
                    }
                });
            }

            @Nonnull
            public Iterable<ChangedValue> getValues() {
                return ImmutableList.of((Object)new ChangedValueImpl("email", "user@atlassian.com", "newuser@atlassian.com"));
            }

            @Nullable
            public AssociatedItem getObjectItem() {
                return new AssociatedItem(){

                    @Nonnull
                    public String getObjectName() {
                        return "user";
                    }

                    @Nullable
                    public String getObjectId() {
                        return "user";
                    }

                    @Nullable
                    public String getParentName() {
                        return "Jira Internal Directory";
                    }

                    @Nullable
                    public String getParentId() {
                        return "1";
                    }

                    @Nonnull
                    public AssociatedItem.Type getObjectType() {
                        return AssociatedItem.Type.USER;
                    }
                };
            }
        };
        DOC_EXAMPLE = new AuditRecordBean(auditRecord, "user management");
        POST_EXAMPLE = new AuditRecordBean(){

            @Override
            @Nonnull
            public String getCategory() {
                return AuditingCategory.USER_MANAGEMENT.toString();
            }

            @Override
            @Nonnull
            public String getSummary() {
                return "User created";
            }

            @Override
            @Nonnull
            public Iterable<AssociatedItemBean> getAssociatedItems() {
                return ImmutableList.of((Object)new AssociatedItemBean(){

                    @Override
                    @Nonnull
                    public String getName() {
                        return "jira-software-users";
                    }

                    @Override
                    @Nullable
                    public String getId() {
                        return "jira-software-users";
                    }

                    @Override
                    @Nullable
                    public String getParentName() {
                        return "Jira Internal Directory";
                    }

                    @Override
                    @Nullable
                    public String getParentId() {
                        return "1";
                    }

                    @Override
                    @Nonnull
                    public String getTypeName() {
                        return AssociatedItem.Type.GROUP.toString();
                    }
                });
            }

            @Override
            @Nonnull
            public Iterable<ChangedValueBean> getChangedValues() {
                return ImmutableList.of((Object)new ChangedValueBean((ChangedValue)new ChangedValueImpl("email", "user@atlassian.com", "newuser@atlassian.com")));
            }

            @Override
            @Nullable
            public AssociatedItemBean getObjectItem() {
                return new AssociatedItemBean(){

                    @Override
                    @Nonnull
                    public String getName() {
                        return "user";
                    }

                    @Override
                    @Nullable
                    public String getId() {
                        return "usr";
                    }

                    @Override
                    @Nullable
                    public String getParentName() {
                        return "Jira Internal Directory";
                    }

                    @Override
                    @Nullable
                    public String getParentId() {
                        return "1";
                    }

                    @Override
                    @Nonnull
                    public String getTypeName() {
                        return AssociatedItem.Type.USER.toString();
                    }
                };
            }
        };
    }
}

