/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.entity.property;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.rest.api.property.PropertiesBean;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;

public final class PropertiesRestLoader<T extends WithId> {
    private final EntityPropertyService<T> service;

    public static <T extends WithId> PropertiesRestLoader<T> withService(EntityPropertyService<T> service) {
        return new PropertiesRestLoader<T>(service);
    }

    private PropertiesRestLoader(EntityPropertyService<T> service) {
        this.service = service;
    }

    public PropertiesBean getProperties(ApplicationUser user, T entity, List<StringList> queryParam) {
        if (queryParam == null || queryParam.isEmpty()) {
            return null;
        }
        IncludedFields includedProperties = IncludedFields.nothingIncludedByDefault(queryParam);
        List properties = includedProperties.includeAll() ? (List)this.service.getProperties(user, entity.getId()).stream().filter(prop -> includedProperties.included(prop.getKey())).collect(CollectorsUtil.toImmutableList()) : this.service.getProperties(user, entity.getId(), (List)Lists.newArrayList(includedProperties.getIncluded()));
        return PropertiesBean.of(properties.stream().collect(Collectors.toMap(EntityProperty::getKey, EntityProperty::getValue)));
    }
}

