/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.index.summary;

import com.atlassian.jira.index.summary.IndexReplicationQueueSummary;
import com.atlassian.jira.index.summary.IssueIndexSummary;
import com.atlassian.jira.rest.v2.index.summary.IndexReplicationQueueEntryBean;
import com.atlassian.jira.rest.v2.index.summary.IndexReplicationQueueSummaryBean;
import com.atlassian.jira.rest.v2.index.summary.IndexSummaryBean;
import com.atlassian.jira.rest.v2.index.summary.IssueIndexSummaryBean;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public class IndexSummaryBeanBuilder {
    private final IndexSummaryBean indexSummaryBean = new IndexSummaryBean();

    public IndexSummaryBeanBuilder nodeId(String nodeId) {
        this.indexSummaryBean.setNodeId(nodeId);
        return this;
    }

    public IndexSummaryBeanBuilder reportTime(Instant time) {
        this.indexSummaryBean.setReportTime(time);
        return this;
    }

    public IndexSummaryBeanBuilder queue(String sourceNodeId, IndexReplicationQueueSummary queue) {
        IndexReplicationQueueSummaryBean queueBean = this.lazyGetReplicationQueue(sourceNodeId);
        queue.getLastOperationInQueue().ifPresent(lastOperationInQueue -> queueBean.setLastOperationInQueue(new IndexReplicationQueueEntryBean(lastOperationInQueue.getId(), lastOperationInQueue.getReplicationTime())));
        queue.getLastConsumedOperation().ifPresent(lastConsumedOperation -> queueBean.setLastConsumedOperation(new IndexReplicationQueueEntryBean(lastConsumedOperation.getId(), lastConsumedOperation.getReplicationTime())));
        queueBean.setQueueSize(queue.getQueueSize());
        return this;
    }

    public IndexSummaryBeanBuilder issueIndex(IssueIndexSummary issueIndexSummary) {
        IssueIndexSummaryBean issueIndexSummaryBean = this.lazyGetIssueIndex();
        if (issueIndexSummary.isIndexReadable()) {
            issueIndexSummaryBean.setIndexReadable(true);
            issueIndexSummaryBean.setCountInDatabase(issueIndexSummary.getCountInDatabase());
            issueIndexSummaryBean.setCountInIndex(issueIndexSummary.getCountInIndex());
            issueIndexSummaryBean.setCountInArchive(issueIndexSummary.getCountInArchive());
            issueIndexSummaryBean.setLastUpdatedInDatabase(issueIndexSummary.getLastUpdatedInDatabase());
            issueIndexSummaryBean.setLastUpdatedInIndex(issueIndexSummary.getLastUpdatedInIndex());
        } else {
            issueIndexSummaryBean.setIndexReadable(false);
        }
        return this;
    }

    private IssueIndexSummaryBean lazyGetIssueIndex() {
        IssueIndexSummaryBean issueIndexSummaryBean = this.indexSummaryBean.getIssueIndex();
        if (issueIndexSummaryBean == null) {
            issueIndexSummaryBean = new IssueIndexSummaryBean();
            this.indexSummaryBean.setIssueIndex(issueIndexSummaryBean);
        }
        return issueIndexSummaryBean;
    }

    private IndexReplicationQueueSummaryBean lazyGetReplicationQueue(String nodeId) {
        Map<String, IndexReplicationQueueSummaryBean> replicationQueues = this.lazyGetReplicationQueues();
        return replicationQueues.computeIfAbsent(nodeId, k -> new IndexReplicationQueueSummaryBean());
    }

    private Map<String, IndexReplicationQueueSummaryBean> lazyGetReplicationQueues() {
        Map<String, IndexReplicationQueueSummaryBean> replicationQueues = this.indexSummaryBean.getReplicationQueues();
        if (replicationQueues == null) {
            replicationQueues = new HashMap<String, IndexReplicationQueueSummaryBean>();
            this.indexSummaryBean.setReplicationQueues(replicationQueues);
        }
        return replicationQueues;
    }

    public IndexSummaryBean build() {
        return this.indexSummaryBean;
    }
}

