/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class AssignIssueResource {
    private final IssueService issueService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Inject
    public AssignIssueResource(JiraAuthenticationContext jiraAuthenticationContext, IssueService issueService) {
        this.issueService = issueService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public Response assignIssue(Issue issue, String assignee) {
        IssueService.AssignValidationResult issueValidationResult = this.issueService.validateAssign(this.callingUser(), issue.getId(), assignee);
        if (!issueValidationResult.isValid()) {
            throw this.error(ErrorCollection.of(issueValidationResult.getErrorCollection()));
        }
        IssueService.IssueResult issueResult = this.issueService.assign(this.callingUser(), issueValidationResult);
        if (!issueResult.isValid()) {
            throw this.error(ErrorCollection.of(issueResult.getErrorCollection()));
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    protected WebApplicationException error(ErrorCollection errors) {
        return new WebApplicationException(Response.status((int)errors.getStatus()).entity((Object)errors).cacheControl(CacheControl.never()).build());
    }

    protected ApplicationUser callingUser() {
        return this.jiraAuthenticationContext.getUser();
    }
}

