/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.jira.rest.serializer.DefaultValueSerializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FieldMetaBean {
    @JsonProperty
    private boolean required;
    @JsonProperty
    private JsonTypeBean schema;
    @JsonProperty
    private String name;
    @JsonProperty
    private String fieldId;
    @JsonProperty
    private String autoCompleteUrl;
    @JsonProperty
    private Boolean hasDefaultValue;
    @JsonProperty
    private Collection<String> operations;
    @JsonProperty
    private Collection<?> allowedValues;
    @JsonProperty
    @JsonSerialize(using=DefaultValueSerializer.class, include=JsonSerialize.Inclusion.NON_NULL)
    private Object defaultValue;
    public static final FieldMetaBean DOC_EXAMPLE = new FieldMetaBean(false, false, JsonTypeBuilder.customArray((String)"option", (String)"com.atlassian.jira.plugin.system.customfieldtypes:multiselect", (Long)10001L), "My Multi Select", "customfield_10000", null, Lists.newArrayList((Object[])new String[]{StandardOperation.SET.getName(), StandardOperation.ADD.getName()}), Lists.newArrayList((Object[])new String[]{"red", "blue", "default value"}), null);
    public static final FieldMetaBean EDIT_META_DOC_EXAMPLE = new FieldMetaBean(false, null, JsonTypeBuilder.customArray((String)"option", (String)"com.atlassian.jira.plugin.system.customfieldtypes:multiselect", (Long)10001L), "My Multi Select", "customfield_10000", null, Lists.newArrayList((Object[])new String[]{StandardOperation.SET.getName(), StandardOperation.ADD.getName()}), Lists.newArrayList((Object[])new String[]{"red", "blue"}), null);

    FieldMetaBean() {
    }

    public FieldMetaBean(boolean required, Boolean hasDefaultValue, JsonType schema, String name, String fieldId, String autoCompleteUrl, Collection<String> operations, Collection<?> allowedValues, Object defaultValue) {
        this.required = required;
        this.hasDefaultValue = hasDefaultValue;
        this.schema = schema == null ? null : new JsonTypeBean(schema);
        this.name = name;
        this.fieldId = fieldId;
        this.autoCompleteUrl = autoCompleteUrl;
        this.operations = operations;
        this.allowedValues = allowedValues;
        this.defaultValue = defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public JsonTypeBean getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getAutoCompleteUrl() {
        return this.autoCompleteUrl;
    }

    public Boolean getHasDefaultValue() {
        return this.hasDefaultValue;
    }

    public Collection<String> getOperations() {
        return this.operations;
    }

    public Collection<?> getAllowedValues() {
        return this.allowedValues;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

