/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.customfield.CreateValidationResult;
import com.atlassian.jira.bc.customfield.CustomFieldDefinition;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.customfield.CustomFieldDefinitionJsonBean;
import com.atlassian.jira.rest.api.field.FieldBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="field")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FieldResource {
    private static final Logger LOG = LoggerFactory.getLogger(FieldResource.class);
    private final FieldManager fieldManager;
    private final JiraAuthenticationContext authenticationContext;
    private final CustomFieldService customFieldService;
    private final SearchHandlerManager searchHandlerManager;
    private final AccessDisablingHelper accessDisablingHelper;
    private final PermissionManager permissionManager;

    @Inject
    public FieldResource(FieldManager fieldManager, JiraAuthenticationContext authenticationContext, CustomFieldService customFieldService, SearchHandlerManager searchHandlerManager, AccessDisablingHelper accessDisablingHelper, PermissionManager permissionManager) {
        this.fieldManager = fieldManager;
        this.authenticationContext = authenticationContext;
        this.customFieldService = customFieldService;
        this.searchHandlerManager = searchHandlerManager;
        this.accessDisablingHelper = accessDisablingHelper;
        this.permissionManager = permissionManager;
    }

    @GET
    public Response getFields() {
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(AccessDisablingHelperConfig.builder().blockAnyoneNotFulfillingCondition(user -> user != null || this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, null)).build())) {
            throw new NotAuthorisedWebException();
        }
        HashSet<Field> fields = new HashSet<Field>();
        Set orderableFields = this.fieldManager.getOrderableFields();
        for (OrderableField orderableField : orderableFields) {
            if (orderableField instanceof NavigableField) continue;
            fields.add((Field)orderableField);
        }
        try {
            fields.addAll(this.fieldManager.getAvailableNavigableFields(this.authenticationContext.getUser()));
        }
        catch (FieldException e) {
            throw new RESTException(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage());
        }
        return Response.ok(FieldBean.shortBeans(fields, this.fieldManager, this.searchHandlerManager)).build();
    }

    @POST
    public Response createCustomField(CustomFieldDefinitionJsonBean customFieldDefinitionJsonBean) {
        CustomFieldDefinition.Builder customFieldDefinitionBuilder = CustomFieldDefinition.builder().name(customFieldDefinitionJsonBean.name()).description(customFieldDefinitionJsonBean.description()).cfType(customFieldDefinitionJsonBean.type()).searcherKey(customFieldDefinitionJsonBean.searcherKey()).isGlobal(customFieldDefinitionJsonBean.projectIds() == null || customFieldDefinitionJsonBean.projectIds().isEmpty()).isAllIssueTypes(customFieldDefinitionJsonBean.issueTypeIds() == null || customFieldDefinitionJsonBean.issueTypeIds().isEmpty());
        if (customFieldDefinitionJsonBean.projectIds() != null) {
            customFieldDefinitionBuilder.addProjectIds(customFieldDefinitionJsonBean.projectIds().toArray(new Long[0]));
        }
        if (customFieldDefinitionJsonBean.issueTypeIds() != null) {
            customFieldDefinitionBuilder.addIssueTypeIds(customFieldDefinitionJsonBean.issueTypeIds().toArray(new String[0]));
        }
        CustomFieldDefinition customFieldDefinition = customFieldDefinitionBuilder.build();
        ServiceOutcome outcome = this.customFieldService.validateCreate(this.authenticationContext.getUser(), customFieldDefinition);
        if (!outcome.isValid()) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(outcome.getErrorCollection()));
        }
        ServiceOutcome serviceOutcome = this.customFieldService.create((CreateValidationResult)outcome.getReturnedValue());
        Field field = this.fieldManager.getField(((CustomField)serviceOutcome.getReturnedValue()).getId());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)FieldBean.shortBean(field, this.fieldManager, this.searchHandlerManager)).build();
    }
}

