/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.rest.json.beans.AttachmentJsonBeanConverter;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.IssueFinder;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartConfig;
import com.atlassian.plugins.rest.api.multipart.MultipartConfigClass;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.ofbiz.core.util.UtilDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.config.Configuration;

@Path(value="issue/{issueIdOrKey}/attachments")
@UnrestrictedAccess
@Produces(value={"application/json"})
public class IssueAttachmentsResource {
    private static final Logger log = LoggerFactory.getLogger(IssueAttachmentsResource.class);
    private final JiraAuthenticationContext authContext;
    private final IssueFinder issueFinder;
    private final AttachmentService attachmentService;
    private final AttachmentManager attachmentManager;
    private final IssueUpdater issueUpdater;
    private final I18nHelper i18n;
    private final AttachmentJsonBeanConverter attachmentJsonBeanConverter;

    @Inject
    public IssueAttachmentsResource(JiraAuthenticationContext authContext, AttachmentService attachmentService, AttachmentManager attachmentManager, IssueUpdater issueUpdater, I18nHelper i18n, IssueFinder issueFinder, @ComponentImport AttachmentJsonBeanConverter attachmentJsonBeanConverter) {
        this.authContext = authContext;
        this.attachmentService = attachmentService;
        this.attachmentManager = attachmentManager;
        this.issueUpdater = issueUpdater;
        this.i18n = i18n;
        this.issueFinder = issueFinder;
        this.attachmentJsonBeanConverter = attachmentJsonBeanConverter;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @MultipartConfigClass(value=JiraAttachmentMultipartConfig.class)
    public Response addAttachment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @MultipartFormParam(value="file") Collection<FilePart> fileParts) {
        MutableIssue issue;
        JiraServiceContextImpl context = new JiraServiceContextImpl(this.authContext.getUser());
        if (!this.attachmentService.canCreateAttachments((JiraServiceContext)context, (Issue)(issue = this.issueFinder.getIssueObject(issueIdOrKey)))) {
            throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(this.i18n.getText("attachment.service.error.create.no.permission")));
        }
        try {
            ArrayList<ChangeItemBean> beans = new ArrayList<ChangeItemBean>(fileParts.size());
            for (FilePart filePart : fileParts) {
                ChangeItemBean bean = this.attachmentManager.createAttachment(this.getFileFromFilePart(filePart), filePart.getName(), filePart.getContentType(), this.authContext.getUser(), (Issue)issue, Collections.emptyMap(), (Date)UtilDateTime.nowTimestamp());
                beans.add(bean);
            }
            IssueUpdateBean issueUpdateBean = new IssueUpdateBean((Issue)issue, (Issue)issue, EventType.ISSUE_UPDATED_ID, this.authContext.getUser());
            issueUpdateBean.setDispatchEvent(true);
            issueUpdateBean.setChangeItems(beans);
            this.issueUpdater.doUpdate(issueUpdateBean, true);
            ArrayList<Attachment> attachments = new ArrayList<Attachment>(beans.size());
            for (ChangeItemBean changeItemBean : beans) {
                Attachment attachment;
                String idStringValue = changeItemBean.getTo();
                if (idStringValue == null || (attachment = this.attachmentManager.getAttachment(Long.valueOf(idStringValue))) == null) continue;
                attachments.add(attachment);
            }
            Collection jsonBeans = this.attachmentJsonBeanConverter.shortBeans(attachments);
            return Response.ok((Object)jsonBeans).cacheControl(CacheControl.never()).build();
        }
        catch (Exception e) {
            log.error("Error saving attachment", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    private File getFileFromFilePart(FilePart filePart) throws IOException {
        File file = File.createTempFile("attachment-", ".tmp");
        file.deleteOnExit();
        filePart.write(file);
        return file;
    }

    private static Integer getMaxAttachmentSize() {
        Integer maxSize;
        try {
            String maxSizeStr = Configuration.getString((String)"webwork.multipart.maxSize");
            if (maxSizeStr != null) {
                try {
                    maxSize = new Integer(maxSizeStr);
                }
                catch (NumberFormatException e) {
                    maxSize = Integer.MAX_VALUE;
                    log.warn("Property 'webwork.multipart.maxSize' with value '" + maxSizeStr + "' is not a number. Defaulting to Integer.MAX_VALUE");
                }
            } else {
                maxSize = Integer.MAX_VALUE;
                log.warn("Property 'webwork.multipart.maxSize' is not set. Defaulting to Integer.MAX_VALUE");
            }
        }
        catch (IllegalArgumentException e1) {
            maxSize = Integer.MAX_VALUE;
            log.warn("Failed getting string from Configuration for 'webwork.multipart.maxSize' property. Defaulting to Integer.MAX_VALUE", (Throwable)e1);
        }
        return maxSize;
    }

    public static class JiraAttachmentMultipartConfig
    implements MultipartConfig {
        public long getMaxFileSize() {
            return IssueAttachmentsResource.getMaxAttachmentSize().intValue();
        }

        public long getMaxSize() {
            return IssueAttachmentsResource.getMaxAttachmentSize() * 10;
        }
    }
}

