/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeCreateBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeUpdateBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.AvatarResourceHelper;
import com.atlassian.jira.rest.v2.issue.IssueTypeBeanBuilder;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="issuetype")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueTypeResource {
    private final JiraAuthenticationContext authContext;
    private final UriInfo contextUriInfo;
    private final JiraBaseUrls jiraBaseUrls;
    private final IssueTypeService issueTypeService;
    private final I18nHelper i18n;
    private final XsrfInvocationChecker xsrfChecker;
    private final AvatarResourceHelper avatarResourceHelper;
    private final GlobalPermissionManager globalPermissionManager;
    private final ResponseFactory responseFactory;

    @Inject
    public IssueTypeResource(JiraAuthenticationContext authContext, UriInfo contextUriInfo, JiraBaseUrls jiraBaseUrls, IssueTypeService issueTypeService, I18nHelper i18n, XsrfInvocationChecker xsrfChecker, AvatarResourceHelper avatarResourceHelper, GlobalPermissionManager globalPermissionManager, ResponseFactory responseFactory) {
        this.authContext = authContext;
        this.contextUriInfo = contextUriInfo;
        this.jiraBaseUrls = jiraBaseUrls;
        this.issueTypeService = issueTypeService;
        this.i18n = i18n;
        this.xsrfChecker = xsrfChecker;
        this.avatarResourceHelper = avatarResourceHelper;
        this.globalPermissionManager = globalPermissionManager;
        this.responseFactory = responseFactory;
    }

    @GET
    public Response getIssueAllTypes() {
        return Response.ok(this.transformIssueTypeToBeans(this.issueTypeService.getIssueTypes(this.authContext.getUser()))).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{id}")
    public Response getIssueType(@PathParam(value="id") String issueTypeId) {
        return (Response)this.issueTypeService.getIssueType(this.authContext.getUser(), issueTypeId).fold((Supplier)new Supplier<Response>(){

            @Override
            public Response get() {
                return IssueTypeResource.this.notFoundResponse();
            }
        }, (Function)new Function<IssueType, Response>(){

            @Override
            public Response apply(IssueType issueType) {
                return Response.ok((Object)IssueTypeResource.this.createIssueTypeBean(issueType)).cacheControl(CacheControl.never()).build();
            }
        });
    }

    @GET
    @Path(value="{id}/alternatives")
    public Response getAlternativeIssueTypes(final @PathParam(value="id") String issueTypeId) {
        ApplicationUser user = this.authContext.getUser();
        Option issueType = this.issueTypeService.getIssueType(user, issueTypeId);
        return (Response)issueType.fold((Supplier)new Supplier<Response>(){

            @Override
            public Response get() {
                return IssueTypeResource.this.notFoundResponse();
            }
        }, (Function)new Function<IssueType, Response>(){

            @Override
            public Response apply(@Nullable IssueType issueType) {
                return Response.ok((Object)IssueTypeResource.this.transformIssueTypeToBeans(IssueTypeResource.this.issueTypeService.getAvailableAlternativesForIssueType(IssueTypeResource.this.authContext.getUser(), issueTypeId))).cacheControl(CacheControl.never()).build();
            }
        });
    }

    @POST
    public Response createIssueType(IssueTypeCreateBean issueTypeCreateBean) {
        ApplicationUser user = this.authContext.getUser();
        IssueTypeService.CreateValidationResult validationResult = this.issueTypeService.validateCreateIssueType(user, this.issueTypeCreateInputFromBean(issueTypeCreateBean));
        if (validationResult.isValid()) {
            IssueTypeService.IssueTypeResult issueTypeResult = this.issueTypeService.createIssueType(user, validationResult);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.createIssueTypeBean(issueTypeResult.getIssueType())).cacheControl(CacheControl.never()).build();
        }
        return this.error(validationResult.getErrorCollection());
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteIssueType(@PathParam(value="id") String issueTypeId, @QueryParam(value="alternativeIssueTypeId") String alternativeIssueTypeId) {
        IssueTypeService.IssueTypeDeleteInput issueTypeDeleteInput;
        ApplicationUser user = this.authContext.getUser();
        IssueTypeService.DeleteValidationResult validationResult = this.issueTypeService.validateDeleteIssueType(user, issueTypeDeleteInput = new IssueTypeService.IssueTypeDeleteInput(issueTypeId, Option.option((Object)alternativeIssueTypeId)));
        if (validationResult.isValid()) {
            this.issueTypeService.deleteIssueType(user, validationResult);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
        }
        return this.error(validationResult.getErrorCollection());
    }

    @PUT
    @Path(value="{id}")
    public Response updateIssueType(@PathParam(value="id") String issueTypeId, IssueTypeUpdateBean issueTypeUpdateBean) {
        IssueTypeService.IssueTypeUpdateInput updateInput;
        ApplicationUser user = this.authContext.getUser();
        IssueTypeService.UpdateValidationResult updateValidationResult = this.issueTypeService.validateUpdateIssueType(user, issueTypeId, updateInput = this.issueTypeUpdateInputFromBean(issueTypeUpdateBean));
        if (updateValidationResult.isValid()) {
            IssueTypeService.IssueTypeResult issueTypeResult = this.issueTypeService.updateIssueType(user, updateValidationResult);
            return Response.ok((Object)this.createIssueTypeBean(issueTypeResult.getIssueType())).cacheControl(CacheControl.never()).build();
        }
        return this.error(updateValidationResult.getErrorCollection());
    }

    @POST
    @Consumes(value={"*/*"})
    @Path(value="{id}/avatar/temporary")
    public Response storeTemporaryAvatar(final @PathParam(value="id") String issueTypeId, final @QueryParam(value="filename") String filename, final @QueryParam(value="size") Long size, final @Context HttpServletRequest request) {
        return (Response)this.validateUploadAttachment(this.authContext.getUser(), issueTypeId).getOrElse((Supplier)new Supplier<Response>(){

            @Override
            public Response get() {
                return IssueTypeResource.this.avatarResourceHelper.storeTemporaryAvatar(IconType.ISSUE_TYPE_ICON_TYPE, issueTypeId, filename, size, request);
            }
        });
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="{id}/avatar/temporary")
    @Produces(value={"text/html"})
    public Response storeTemporaryAvatarUsingMultiPart(final @PathParam(value="id") String issueTypeId, final @MultipartFormParam(value="avatar") FilePart filePart, final @Context HttpServletRequest request) {
        return (Response)this.validateUploadAttachment(this.authContext.getUser(), issueTypeId).getOrElse((Supplier)new Supplier<Response>(){

            @Override
            public Response get() {
                return IssueTypeResource.this.avatarResourceHelper.storeTemporaryAvatarUsingMultiPart(IconType.ISSUE_TYPE_ICON_TYPE, issueTypeId, filePart, request);
            }
        });
    }

    @POST
    @Path(value="{id}/avatar")
    public Response createAvatarFromTemporary(final @PathParam(value="id") String issueTypeId, final AvatarCroppingBean croppingInstructions) {
        return (Response)this.validateUploadAttachment(this.authContext.getUser(), issueTypeId).getOrElse((Supplier)new Supplier<Response>(){

            @Override
            public Response get() {
                return IssueTypeResource.this.avatarResourceHelper.createAvatarFromTemporary(IconType.ISSUE_TYPE_ICON_TYPE, issueTypeId, croppingInstructions);
            }
        });
    }

    @GET
    @Path(value="page")
    @Produces(value={"application/json"})
    @ExperimentalApi
    public Response getPaginatedIssueTypes(@Context UriInfo uriInfo, @HeaderParam(value="X-Requested-With") String requestedWith, @DefaultValue(value="0") @QueryParam(value="startAt") Long startAt, @DefaultValue(value="100") @QueryParam(value="maxResults") Integer maxResults, @DefaultValue(value="") @QueryParam(value="query") String query, @QueryParam(value="projectIds") Set<Long> projectIds) {
        ApplicationUser user = this.authContext.getLoggedInUser();
        Stream issueTypeStream = projectIds.isEmpty() ? this.issueTypeService.findIssueTypes(user, query) : this.issueTypeService.findIssueTypes(user, query, projectIds);
        PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)maxResults);
        Page statusPage = Pages.toPage(() -> issueTypeStream.sorted(Comparator.comparing(IssueConstant::getName)).iterator(), (PageRequest)pageRequest);
        PageBean<IssueTypeJsonBean> bean = PageBean.from(pageRequest, statusPage).build(issueType -> IssueTypeJsonBean.shortBean((IssueType)issueType, (JiraBaseUrls)this.jiraBaseUrls));
        return Response.ok(bean).cacheControl(CacheControl.never()).build();
    }

    private Option<Response> validateUploadAttachment(ApplicationUser user, String issueTypeId) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (user == null) {
            return Option.some((Object)Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in"))).cacheControl(CacheControl.never()).build());
        }
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return Option.some((Object)Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorCollection.of(this.i18n.getText("rest.authorization.admin.required"))).cacheControl(CacheControl.never()).build());
        }
        if (this.issueTypeService.getIssueType(user, issueTypeId).isEmpty()) {
            return Option.some((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("admin.error.issue.type.update.not.exist"))).cacheControl(CacheControl.never()).build());
        }
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            return Option.some((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"XSRF check failed").build());
        }
        return Option.none(Response.class);
    }

    private Response error(com.atlassian.jira.util.ErrorCollection errorCollection) {
        ErrorCollection.Reason reason = ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons());
        return Response.status((int)reason.getHttpStatusCode()).entity((Object)ErrorCollection.of(errorCollection)).cacheControl(CacheControl.never()).build();
    }

    private List<IssueTypeJsonBean> transformIssueTypeToBeans(Iterable<IssueType> issueTypes) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(issueTypes, this::createIssueTypeBean));
    }

    private IssueTypeJsonBean createIssueTypeBean(IssueType issueType) {
        return new IssueTypeBeanBuilder().jiraBaseUrls(this.jiraBaseUrls).context(this.contextUriInfo).issueType(issueType).build();
    }

    private IssueTypeService.IssueTypeCreateInput issueTypeCreateInputFromBean(IssueTypeCreateBean issueTypeCreateBean) {
        return IssueTypeService.IssueTypeCreateInput.builder().setDescription(issueTypeCreateBean.getDescription()).setName(issueTypeCreateBean.getName()).setType(issueTypeCreateBean.getType() == IssueTypeCreateBean.Type.standard ? IssueTypeService.IssueTypeCreateInput.Type.STANDARD : IssueTypeService.IssueTypeCreateInput.Type.SUBTASK).build();
    }

    private IssueTypeService.IssueTypeUpdateInput issueTypeUpdateInputFromBean(IssueTypeUpdateBean issueTypeUpdateBean) {
        return IssueTypeService.IssueTypeUpdateInput.builder().setDescription(issueTypeUpdateBean.getDescription()).setName(issueTypeUpdateBean.getName()).setAvatarId(issueTypeUpdateBean.getAvatarId()).build();
    }

    private Response notFoundResponse() {
        return this.responseFactory.notFound("admin.error.issue.type.get.not.exist", new String[0]);
    }
}

