/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.SecuritySchemeJsonBean;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.issue.security.IssueSecuritySchemeService;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="project/{projectKeyOrId}/issuesecuritylevelscheme")
@Produces(value={"application/json"})
public class ProjectIssueSecurityLevelSchemeResource {
    private final IssueSecuritySchemeService issueSecuritySchemeService;
    private final ResponseFactory responseFactory;
    private final JiraBaseUrls baseUrls;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Inject
    public ProjectIssueSecurityLevelSchemeResource(IssueSecuritySchemeService issueSecuritySchemeService, ResponseFactory responseFactory, JiraBaseUrls baseUrls, JiraAuthenticationContext jiraAuthenticationContext) {
        this.issueSecuritySchemeService = issueSecuritySchemeService;
        this.responseFactory = responseFactory;
        this.baseUrls = baseUrls;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    public Response getIssueSecurityScheme(@PathParam(value="projectKeyOrId") String projectKeyOrId) {
        final ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ServiceOutcome<IssueSecurityLevelScheme> issueSecurityLevelScheme = this.getIssueSecurityLevelScheme(user, projectKeyOrId);
        return (Response)this.responseFactory.validateOutcome(issueSecurityLevelScheme).left().on((Function)new Function<IssueSecurityLevelScheme, Response>(){

            @Override
            public Response apply(final IssueSecurityLevelScheme securityLevelScheme) {
                ServiceOutcome issueSecurityLevels = ProjectIssueSecurityLevelSchemeResource.this.issueSecuritySchemeService.getIssueSecurityLevels(user, securityLevelScheme.getId().longValue());
                return (Response)ProjectIssueSecurityLevelSchemeResource.this.responseFactory.validateOutcome(issueSecurityLevels).left().on((Function)new Function<List<IssueSecurityLevel>, Response>(){

                    @Override
                    public Response apply(List<IssueSecurityLevel> issueSecurityLevels) {
                        return ProjectIssueSecurityLevelSchemeResource.this.responseFactory.okNoCache(SecuritySchemeJsonBean.fullBean((IssueSecurityLevelScheme)securityLevelScheme, (JiraBaseUrls)ProjectIssueSecurityLevelSchemeResource.this.baseUrls, issueSecurityLevels));
                    }
                });
            }
        });
    }

    private ServiceOutcome<IssueSecurityLevelScheme> getIssueSecurityLevelScheme(ApplicationUser user, String projectKeyOrId) {
        try {
            return this.issueSecuritySchemeService.getIssueSecurityLevelSchemeForProject(user, Long.parseLong(projectKeyOrId));
        }
        catch (NumberFormatException e) {
            return this.issueSecuritySchemeService.getIssueSecurityLevelSchemeForProject(user, projectKeyOrId);
        }
    }
}

