/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.project.property.ProjectPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanSelfFunctions;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyWithKeyResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.google.common.base.Predicate;
import java.util.function.BiFunction;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="project/{projectIdOrKey}/properties")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProjectPropertyResource {
    private final BasePropertyWithKeyResource<Project> delegate;

    @Inject
    public ProjectPropertyResource(ProjectPropertyService projectPropertyService, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n) {
        this.delegate = new BasePropertyWithKeyResource(projectPropertyService, authContext, jiraBaseUrls, i18n, new IsValidProjectKeyPredicate(), (BiFunction<Long, String, String>)new EntityPropertyBeanSelfFunctions.ProjectPropertySelfBiFunction(), EntityPropertyType.ISSUE_PROPERTY);
    }

    @ExperimentalApi
    @GET
    public Response getPropertiesKeys(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        return this.delegate.getPropertiesKeys(projectIdOrKey);
    }

    @ExperimentalApi
    @PUT
    @Path(value="/{propertyKey}")
    public Response setProperty(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) {
        return this.delegate.setProperty(projectIdOrKey, propertyKey, request);
    }

    @ExperimentalApi
    @GET
    @Path(value="/{propertyKey}")
    public Response getProperty(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.getProperty(projectIdOrKey, propertyKey);
    }

    @ExperimentalApi
    @DELETE
    @Path(value="/{propertyKey}")
    public Response deleteProperty(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.deleteProperty(projectIdOrKey, propertyKey);
    }

    private static class IsValidProjectKeyPredicate
    implements Predicate<String> {
        private IsValidProjectKeyPredicate() {
        }

        public boolean apply(String projectKey) {
            return JiraKeyUtils.validProjectKey((String)projectKey);
        }
    }
}

