/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TimeTrackingBean {
    @XmlElement
    private String originalEstimate;
    @XmlElement
    private String remainingEstimate;
    @XmlElement
    private String timeSpent;
    @XmlElement
    private Long originalEstimateSeconds;
    @XmlElement
    private Long remainingEstimateSeconds;
    @XmlElement
    private Long timeSpentSeconds;

    public TimeTrackingBean(Long originalEstimateSeconds, Long estimateSeconds, Long timeSpentSeconds) {
        this.originalEstimateSeconds = originalEstimateSeconds;
        this.remainingEstimateSeconds = estimateSeconds;
        this.timeSpentSeconds = timeSpentSeconds;
        this.originalEstimate = this.secondsToFormattedMinutes(originalEstimateSeconds);
        this.remainingEstimate = this.secondsToFormattedMinutes(estimateSeconds);
        this.timeSpent = this.secondsToFormattedMinutes(timeSpentSeconds);
    }

    public boolean hasValues() {
        return this.originalEstimateSeconds != null || this.remainingEstimateSeconds != null || this.timeSpentSeconds != null;
    }

    public String getOriginalEstimate() {
        return this.originalEstimate;
    }

    public void setOriginalEstimate(String originalEstimate) {
        this.originalEstimate = originalEstimate;
    }

    public String getRemainingEstimate() {
        return this.remainingEstimate;
    }

    public void setRemainingEstimate(String remainingEstimate) {
        this.remainingEstimate = remainingEstimate;
    }

    public String getTimeSpent() {
        return this.timeSpent;
    }

    public void setTimeSpent(String timeSpent) {
        this.timeSpent = timeSpent;
    }

    public Long getOriginalEstimateSeconds() {
        return this.originalEstimateSeconds;
    }

    public void setOriginalEstimateSeconds(Long originalEstimateSeconds) {
        this.originalEstimateSeconds = originalEstimateSeconds;
    }

    public Long getRemainingEstimateSeconds() {
        return this.remainingEstimateSeconds;
    }

    public void setRemainingEstimateSeconds(Long remainingEstimateSeconds) {
        this.remainingEstimateSeconds = remainingEstimateSeconds;
    }

    public Long getTimeSpentSeconds() {
        return this.timeSpentSeconds;
    }

    public void setTimeSpentSeconds(Long timeSpentSeconds) {
        this.timeSpentSeconds = timeSpentSeconds;
    }

    private String secondsToFormattedMinutes(Long seconds) {
        return seconds != null ? String.format("%dm", seconds / 60L) : null;
    }
}

