/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.WorkflowIssueOperationImpl;
import com.atlassian.jira.rest.v2.issue.AbstractMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.FieldMetaBean;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Pair;
import java.util.Map;
import java.util.stream.Stream;

public class TransitionMetaFieldBeanBuilder
extends AbstractMetaFieldBeanBuilder {
    private final ActionDescriptor action;
    private FieldScreenRenderer fieldScreenRenderer;

    public TransitionMetaFieldBeanBuilder(FieldScreenRendererFactory fieldScreenRendererFactory, FieldLayoutManager fieldLayoutManager, ActionDescriptor action, Issue issue, ApplicationUser user, VersionBeanFactory versionBeanFactory, VelocityRequestContextFactory velocityRequestContextFactory, JiraBaseUrls baseUrls) {
        super(fieldLayoutManager, issue.getProjectObject(), issue, issue.getIssueTypeObject(), user, versionBeanFactory, velocityRequestContextFactory, baseUrls, null);
        this.action = action;
        this.fieldScreenRenderer = fieldScreenRendererFactory.getFieldScreenRenderer(user, issue, action);
    }

    @Override
    public OperationContext getOperationContext() {
        return new OperationContext(){

            public Map getFieldValuesHolder() {
                return null;
            }

            public IssueOperation getIssueOperation() {
                return new WorkflowIssueOperationImpl(TransitionMetaFieldBeanBuilder.this.action);
            }
        };
    }

    @Override
    public Map<String, FieldMetaBean> build() {
        return (Map)this.getFieldScreenRenderLayoutItems().filter(fieldScreenRenderLayoutItem -> fieldScreenRenderLayoutItem.isShow(this.issue)).map(fieldScreenRenderLayoutItem -> {
            OrderableField field = fieldScreenRenderLayoutItem.getOrderableField();
            FieldLayoutItem fieldLayoutItem = fieldScreenRenderLayoutItem.getFieldLayoutItem();
            FieldMetaBean fieldMetaBean = "resolution".equals(field.getId()) ? this.getFieldMetaBean(true, field) : this.getFieldMetaBean(fieldLayoutItem.isRequired(), field);
            return Pair.pair((Object)field.getId(), (Object)fieldMetaBean);
        }).collect(CollectorsUtil.toImmutableMap(Pair::left, Pair::right));
    }

    @Override
    protected Stream<String> getAdditionalKeys() {
        return Stream.empty();
    }

    @Override
    public boolean hasPermissionToPerformOperation() {
        return true;
    }

    @Override
    Stream<FieldScreenRenderTab> getFieldScreenRenderTabsStream(Issue issue) {
        return this.fieldScreenRenderer.getFieldScreenRenderTabs().stream();
    }
}

