/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.config.util.AttachmentConfigManager;
import com.atlassian.jira.plugin.attachment.AttachmentArchive;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.issue.attachment.AttachmentResourceStrategy;
import com.atlassian.jira.rest.v2.issue.attachment.AttachmentStrategyFactory;
import com.atlassian.jira.rest.v2.issue.attachment.authorization.AttachmentAuthorizer;
import com.atlassian.jira.rest.v2.issue.attachment.format.ArchiveFormatter;
import com.atlassian.jira.rest.v2.issue.attachment.format.AttachmentMetaBean;
import com.atlassian.jira.rest.v2.issue.attachment.format.HumanReadableArchive;
import com.atlassian.jira.rest.v2.issue.attachment.operation.AttachmentOperation;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import webwork.config.Configuration;

@Path(value="attachment")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AttachmentResource {
    private AttachmentStrategyFactory factory;
    private AttachmentConfigManager attachmentConfigManager;

    private AttachmentResource() {
    }

    @Inject
    public AttachmentResource(AttachmentStrategyFactory factory, AttachmentConfigManager attachmentConfigManager) {
        this.factory = factory;
        this.attachmentConfigManager = Objects.requireNonNull(attachmentConfigManager);
    }

    @GET
    @Path(value="{id}")
    public Response getAttachment(@PathParam(value="id") String id) {
        AttachmentAuthorizer authorizer = this.factory.authorizer().view();
        AttachmentOperation operation = this.factory.operation().view();
        AttachmentResourceStrategy strategy = this.factory.resourceStrategy(authorizer, operation);
        return strategy.processAttachment(id);
    }

    @DELETE
    @Path(value="{id}")
    public Response removeAttachment(@PathParam(value="id") String id) {
        AttachmentAuthorizer authorizer = this.factory.authorizer().removal();
        AttachmentOperation operation = this.factory.operation().removal();
        AttachmentResourceStrategy strategy = this.factory.resourceStrategy(authorizer, operation);
        return strategy.processAttachment(id);
    }

    @GET
    @Path(value="meta")
    public Response getAttachmentMeta() {
        boolean enabled = this.attachmentConfigManager.isAttachmentsEnabled();
        long maxSize = Long.parseLong(Configuration.getString((String)"webwork.multipart.maxSize"));
        AttachmentMetaBean bean = new AttachmentMetaBean(enabled, maxSize);
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{id}/expand/raw")
    @ExperimentalApi
    public Response expandForMachines(@PathParam(value="id") String id) {
        AttachmentAuthorizer authorizer = this.factory.authorizer().view();
        ArchiveFormatter<AttachmentArchive> formatter = this.factory.formatter().raw();
        AttachmentOperation operation = this.factory.operation().expansion(formatter);
        AttachmentResourceStrategy strategy = this.factory.resourceStrategy(authorizer, operation);
        return strategy.processAttachment(id);
    }

    @GET
    @Path(value="{id}/expand/human")
    @ExperimentalApi
    public Response expandForHumans(@PathParam(value="id") String id) {
        AttachmentAuthorizer authorizer = this.factory.authorizer().view();
        ArchiveFormatter<HumanReadableArchive> formatter = this.factory.formatter().human();
        AttachmentOperation operation = this.factory.operation().expansion(formatter);
        AttachmentResourceStrategy strategy = this.factory.resourceStrategy(authorizer, operation);
        return strategy.processAttachment(id);
    }
}

