/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment.authorization;

import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.rest.factory.JiraServiceContextFactory;
import com.atlassian.jira.rest.v2.issue.attachment.authorization.AttachmentAuthorizer;
import com.atlassian.jira.rest.v2.issue.attachment.authorization.AttachmentRemovalAuthorizer;
import com.atlassian.jira.rest.v2.issue.attachment.authorization.AttachmentViewAuthorizer;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class AttachmentAuthorizerFactory {
    private AttachmentService attachmentService;
    private JiraServiceContextFactory contextFactory;
    private PermissionManager permissionManager;

    private AttachmentAuthorizerFactory() {
    }

    @Autowired
    private AttachmentAuthorizerFactory(AttachmentService attachmentService, JiraServiceContextFactory contextFactory, PermissionManager permissionManager) {
        this.attachmentService = attachmentService;
        this.contextFactory = contextFactory;
        this.permissionManager = permissionManager;
    }

    public AttachmentAuthorizer removal() {
        return new AttachmentRemovalAuthorizer(this.attachmentService, this.contextFactory);
    }

    public AttachmentAuthorizer view() {
        return new AttachmentViewAuthorizer(this.permissionManager);
    }
}

