/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.component;

import com.atlassian.jira.rest.v2.issue.Examples;
import java.net.URI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XmlRootElement(name="component")
public class ComponentIssueCountsBean {
    static final ComponentIssueCountsBean DOC_EXAMPLE;
    @XmlElement
    private URI self;
    @XmlElement
    private long issueCount;

    public long getIssueCount() {
        return this.issueCount;
    }

    public URI getSelf() {
        return this.self;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public ComponentIssueCountsBean() {
    }

    ComponentIssueCountsBean(long issueCount, URI self) {
        this.self = self;
        this.issueCount = issueCount;
    }

    static {
        ComponentIssueCountsBean bean = new ComponentIssueCountsBean();
        bean.self = Examples.restURI("component/10000");
        bean.issueCount = 23L;
        DOC_EXAMPLE = bean;
    }

    public static class Builder {
        private URI self;
        private long issuesAffectedCount;
        private long issueCount;

        public URI getSelf() {
            return this.self;
        }

        public Builder setSelf(URI self) {
            this.self = self;
            return this;
        }

        public Builder issueCount(long issueCount) {
            this.issueCount = issueCount;
            return this;
        }

        public Builder issuesAffectedCount(long issuesAffectedCount) {
            this.issuesAffectedCount = issuesAffectedCount;
            return this;
        }

        public ComponentIssueCountsBean build() {
            return new ComponentIssueCountsBean(this.issueCount, this.self);
        }
    }
}

