/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.customfield;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.customfield.DefaultCustomFieldService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.issue.field.CustomFieldsBulkDeleteEvent;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.managers.CustomFieldBulkDeleteManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.customfield.BulkDeleteResponseBean;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldBean;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldBeanFactory;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldFindEvent;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldOptionBean;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldOptionBeanBuilder;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldOptionsBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="customFields")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CustomFieldResource {
    private static final String ACCESSED_FROM_SERVER_OR_FLAG_OFF_MESSAGE = "rest.customfield.bulk.delete.not.available";
    private static final String WRONG_ARGUMENTS_MESSAGE = "rest.customfield.bulk.delete.wrong.arguments";
    private static final String NO_CUSTOM_FIELD_DELETED_MESSAGE = "rest.customfield.bulk.delete.nothing.deleted";
    private static final String OPERATION_FINISHED_MESSAGE = "rest.customfield.bulk.delete.operation.finished";
    private static final String COULD_NOT_OBTAIN_LOCK_MESSAGE = "rest.customfield.bulk.delete.no.lock";
    private static final String REQUEST_ERROR = "Request error";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CustomFieldBeanFactory customFieldBeanFactory;
    private final DefaultCustomFieldService customFieldService;
    private final OptionsManager optionsManager;
    private final UriInfo contextUriInfo;
    private final EventPublisher eventPublisher;
    private final CustomFieldBulkDeleteManager customFieldBulkDeleteManager;
    private final I18nHelper i18n;

    @Inject
    public CustomFieldResource(JiraAuthenticationContext jiraAuthenticationContext, CustomFieldBeanFactory customFieldBeanFactory, OptionsManager optionsManager, UriInfo contextUriInfo, EventPublisher eventPublisher, I18nHelper i18nHelper) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.customFieldBeanFactory = customFieldBeanFactory;
        this.optionsManager = optionsManager;
        this.contextUriInfo = contextUriInfo;
        this.i18n = i18nHelper;
        this.customFieldService = (DefaultCustomFieldService)ComponentAccessor.getComponent(DefaultCustomFieldService.class);
        this.eventPublisher = eventPublisher;
        this.customFieldBulkDeleteManager = (CustomFieldBulkDeleteManager)ComponentAccessor.getComponent(CustomFieldBulkDeleteManager.class);
    }

    @GET
    public Response getCustomFields(@DefaultValue(value="1") @QueryParam(value="startAt") long startAt, @DefaultValue(value="50") @QueryParam(value="maxResults") int maxResults, @QueryParam(value="search") String searchString, @QueryParam(value="projectIds") List<String> projectIds, @QueryParam(value="screenIds") List<String> screenIds, @QueryParam(value="types") List<String> types, @QueryParam(value="sortOrder") String sortOrder, @QueryParam(value="sortColumn") String sortColumn, @QueryParam(value="lastValueUpdate") Long lastValueUpdate) {
        long pageStart = (startAt - 1L) * (long)maxResults;
        ServiceOutcomeImpl customfields = this.customFieldService.findCustomFields(this.jiraAuthenticationContext.getLoggedInUser(), searchString, types, projectIds, screenIds, sortOrder, sortColumn, lastValueUpdate);
        this.eventPublisher.publish((Object)new CustomFieldFindEvent(startAt, maxResults, projectIds, screenIds, types, sortOrder, sortColumn, lastValueUpdate));
        if (!customfields.isValid()) {
            return CustomFieldResource.createErrorResponse((ServiceResult)customfields);
        }
        PageRequest pageRequest = PageRequests.request((Long)pageStart, (Integer)maxResults);
        Page customFieldPage = Pages.toPage((Iterable)((Iterable)customfields.getReturnedValue()), (PageRequest)pageRequest);
        PageBean<CustomFieldBean> bean = PageBean.from(pageRequest, customFieldPage).build(this.customFieldBeanFactory::from);
        return Response.ok(bean).cacheControl(CacheControl.never()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    public Response bulkDeleteCustomFields(@QueryParam(value="ids") List<String> customFieldsIds) {
        long startTime = System.currentTimeMillis();
        int selectedCustomFields = customFieldsIds != null ? customFieldsIds.size() : 0;
        int deletedCustomFields = 0;
        int status = 0;
        try {
            if (!this.customFieldBulkDeleteManager.isDCAndFeatureFlagOn()) {
                status = 503;
                Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)new BulkDeleteResponseBean(this.i18n.getText(ACCESSED_FROM_SERVER_OR_FLAG_OFF_MESSAGE, CustomFieldBulkDeleteManager.BULK_DELETE_FEATURE_FLAG), Collections.emptyList(), customFieldsIds == null ? Collections.emptyMap() : customFieldsIds.stream().collect(Collectors.toMap(cf -> cf, cf -> REQUEST_ERROR)))).build();
                return response;
            }
            if (!this.customFieldBulkDeleteManager.validateNumberOfArguments(customFieldsIds)) {
                status = 400;
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new BulkDeleteResponseBean(this.i18n.getText(WRONG_ARGUMENTS_MESSAGE, (Object)50), Collections.emptyList(), customFieldsIds == null ? Collections.emptyMap() : customFieldsIds.stream().collect(Collectors.toMap(cf -> cf, cf -> REQUEST_ERROR)))).build();
                return response;
            }
            Map notDeletedCustomFields = this.customFieldBulkDeleteManager.validateAndDeleteCustomFields(this.jiraAuthenticationContext, customFieldsIds, Long.valueOf(startTime));
            if (notDeletedCustomFields.size() == customFieldsIds.size()) {
                status = 400;
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new BulkDeleteResponseBean(this.i18n.getText(NO_CUSTOM_FIELD_DELETED_MESSAGE), Collections.emptyList(), notDeletedCustomFields)).build();
                return response;
            }
            List<String> deletedCustomFieldsList = customFieldsIds.stream().filter(cf -> !notDeletedCustomFields.containsKey(cf)).collect(Collectors.toList());
            status = 200;
            deletedCustomFields = deletedCustomFieldsList.size();
            Response response = Response.ok().entity((Object)new BulkDeleteResponseBean(this.i18n.getText(OPERATION_FINISHED_MESSAGE), deletedCustomFieldsList, notDeletedCustomFields)).build();
            return response;
        }
        catch (CustomFieldBulkDeleteManager.LockNotAcquiredException e) {
            status = 423;
            Response response = Response.status((int)423).entity((Object)new BulkDeleteResponseBean(this.i18n.getText(COULD_NOT_OBTAIN_LOCK_MESSAGE), Collections.emptyList(), customFieldsIds == null ? Collections.emptyMap() : customFieldsIds.stream().collect(Collectors.toMap(cf -> cf, cf -> REQUEST_ERROR)))).build();
            return response;
        }
        finally {
            this.eventPublisher.publish((Object)new CustomFieldsBulkDeleteEvent(Long.valueOf(startTime), Long.valueOf(System.currentTimeMillis()), selectedCustomFields, deletedCustomFields, status));
        }
    }

    @GET
    @Path(value="{customFieldId}/options")
    @ExperimentalApi
    public Response getCustomFieldOptions(@PathParam(value="customFieldId") long customFieldId, @QueryParam(value="projectIds") List<Long> projectIds, @QueryParam(value="issueTypeIds") List<String> issueTypeIds, @QueryParam(value="query") @DefaultValue(value="") String query, @QueryParam(value="maxResults") @DefaultValue(value="100") int maxResults, @QueryParam(value="page") @DefaultValue(value="1") int page) {
        ServiceOutcome fieldOutcome = this.customFieldService.getCustomField(this.jiraAuthenticationContext.getLoggedInUser(), Long.valueOf(customFieldId));
        if (!fieldOutcome.isValid()) {
            return CustomFieldResource.createErrorResponse((ServiceResult)fieldOutcome);
        }
        List rootOptions = this.optionsManager.getOptions((CustomField)fieldOutcome.get(), projectIds, issueTypeIds);
        List<Option> allOptions = rootOptions.stream().flatMap(option -> {
            ArrayList<Option> optionsList = new ArrayList<Option>();
            optionsList.add((Option)option);
            optionsList.addAll(option.retrieveAllChildren(null));
            return optionsList.stream();
        }).collect(Collectors.toList());
        List<Option> filteredOptions = this.filterOptionsByQuery(allOptions, query);
        List<CustomFieldOptionBean> optionBeans = filteredOptions.stream().skip((long)(page - 1) * (long)maxResults).map(option -> new CustomFieldOptionBeanBuilder().customFieldOption((Option)option).context(this.contextUriInfo).build()).limit(maxResults).collect(Collectors.toList());
        return Response.ok((Object)new CustomFieldOptionsBean(optionBeans, filteredOptions.size())).cacheControl(CacheControl.never()).build();
    }

    private List<Option> filterOptionsByQuery(Collection<Option> options, String query) {
        Pattern pattern = ConstantsManager.createIssueConstantNameSearchPattern((String)query);
        return options.stream().filter(option -> pattern.matcher(option.getValue()).matches()).collect(Collectors.toList());
    }

    public static Response createErrorResponse(ServiceResult result) {
        Set reasons = result.getErrorCollection().getReasons();
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)reasons);
        if (worstReason == null) {
            worstReason = ErrorCollection.Reason.NOT_FOUND;
        }
        return Response.status((int)worstReason.getHttpStatusCode()).entity((Object)ErrorCollection.of(result.getErrorCollection())).cacheControl(CacheControl.never()).build();
    }
}

