/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.project.ProjectRoleBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.ProjectFinder;
import com.atlassian.jira.rest.v2.issue.Examples;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleActorsUpdateBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="project/{projectIdOrKey}/role")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProjectRoleResource {
    ProjectRoleService projectRoleService;
    AvatarService avatarService;
    ProjectFinder projectFinder;
    JiraAuthenticationContext authContext;
    UriInfo uriInfo;
    UserManager userManager;
    ProjectRoleBeanFactory projectRoleBeanFactory;
    GroupManager groupManager;
    public static Map<String, String> GET_ROLES_DOC_EXAMPLE = MapBuilder.newBuilder().add((Object)"Developers", (Object)Examples.restURI("project", "MKY", "role", "10000").toString()).add((Object)"Users", (Object)Examples.restURI("project", "MKY", "role", "10001").toString()).add((Object)"Administrators", (Object)Examples.restURI("project", "MKY", "role", "10002").toString()).toMap();

    private ProjectRoleResource() {
    }

    @Inject
    public ProjectRoleResource(ProjectRoleService projectRoleService, AvatarService avatarService, ProjectFinder projectFinder, JiraAuthenticationContext authContext, UriInfo uriInfo, UserManager userManager, ProjectRoleBeanFactory projectRoleBeanFactory, GroupManager groupManager) {
        this.projectRoleService = projectRoleService;
        this.avatarService = avatarService;
        this.projectFinder = projectFinder;
        this.authContext = authContext;
        this.uriInfo = uriInfo;
        this.userManager = userManager;
        this.projectRoleBeanFactory = projectRoleBeanFactory;
        this.groupManager = groupManager;
    }

    @GET
    public Response getProjectRoles(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        Project project = this.getProjectByIdOrKey(projectIdOrKey);
        HashMap<String, URI> roles = new HashMap<String, URI>();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Collection projectRoles = this.projectRoleService.getProjectRoles((com.atlassian.jira.util.ErrorCollection)errorCollection);
        if (!errorCollection.hasAnyErrors()) {
            for (ProjectRole projectRole : projectRoles) {
                URI uri = this.projectRoleBeanFactory.projectRole((Project)project, (ProjectRole)projectRole).self;
                roles.put(projectRole.getName(), uri);
            }
        }
        return Response.ok(roles).build();
    }

    @GET
    @Path(value="{id}")
    public Response getProjectRole(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="id") Long id) {
        Project project = this.getProjectByIdOrKey(projectIdOrKey);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole projectRole = this.projectRoleService.getProjectRole(id, (com.atlassian.jira.util.ErrorCollection)errorCollection);
        this.checkForErrors(errorCollection);
        SimpleErrorCollection projectActorsErrorCollection = new SimpleErrorCollection();
        ProjectRoleActors projectRoleActors = this.projectRoleService.getProjectRoleActors(projectRole, project, (com.atlassian.jira.util.ErrorCollection)projectActorsErrorCollection);
        this.checkForErrors(projectActorsErrorCollection);
        ProjectRoleBean projectRoleBean = this.projectRoleBeanFactory.projectRole(project, projectRole, projectRoleActors, this.authContext.getUser());
        return Response.ok((Object)projectRoleBean).build();
    }

    @PUT
    @Path(value="{id}")
    public Response setActors(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="id") Long id, ProjectRoleActorsUpdateBean actors) {
        Project project = this.getProjectByIdOrKey(projectIdOrKey);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole projectRole = this.projectRoleService.getProjectRole(id, (com.atlassian.jira.util.ErrorCollection)errorCollection);
        this.checkForErrors(errorCollection);
        Map<String, String[]> simpleActors = actors.getCategorisedActors();
        String[] usernames = simpleActors.get("atlassian-user-role-actor");
        String[] groupnames = simpleActors.get("atlassian-group-role-actor");
        if (usernames == null && groupnames == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Set<String> userKeys = this.userkeysFromUsernames(usernames);
        Set<String> existingGroupnames = this.existingGroupNames(groupnames);
        HashMap newRoleActors = Maps.newHashMap();
        newRoleActors.put("atlassian-user-role-actor", userKeys);
        newRoleActors.put("atlassian-group-role-actor", existingGroupnames);
        SimpleErrorCollection setActorErrorCollection = new SimpleErrorCollection();
        this.projectRoleService.setActorsForProjectRole((Map)newRoleActors, projectRole, project, (com.atlassian.jira.util.ErrorCollection)setActorErrorCollection);
        this.checkForErrors(setActorErrorCollection);
        return this.getProjectRole(projectIdOrKey, id);
    }

    @POST
    @Path(value="{id}")
    public Response addActorUsers(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="id") Long id, ActorsMap actors) {
        Project project = this.getProjectByIdOrKey(projectIdOrKey);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole projectRole = this.projectRoleService.getProjectRole(id, (com.atlassian.jira.util.ErrorCollection)errorCollection);
        this.checkForErrors(errorCollection);
        String[] usernames = (String[])actors.get("user");
        String[] groupnames = (String[])actors.get("group");
        if (usernames == null && groupnames == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Set<String> userKeys = this.userkeysFromUsernames(usernames);
        Set<String> existingGroupnames = this.existingGroupNames(groupnames);
        if (userKeys.isEmpty() && existingGroupnames.isEmpty()) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        if (!userKeys.isEmpty()) {
            SimpleErrorCollection addActorUserErrorCollection = new SimpleErrorCollection();
            this.projectRoleService.addActorsToProjectRole(userKeys, projectRole, project, "atlassian-user-role-actor", (com.atlassian.jira.util.ErrorCollection)addActorUserErrorCollection);
            this.checkForErrors(addActorUserErrorCollection);
        }
        if (!existingGroupnames.isEmpty()) {
            SimpleErrorCollection addActorGroupnameErrorCollection = new SimpleErrorCollection();
            this.projectRoleService.addActorsToProjectRole(existingGroupnames, projectRole, project, "atlassian-group-role-actor", (com.atlassian.jira.util.ErrorCollection)addActorGroupnameErrorCollection);
            this.checkForErrors(addActorGroupnameErrorCollection);
        }
        return this.getProjectRole(projectIdOrKey, id);
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteActor(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="id") Long id, @QueryParam(value="user") String username, @QueryParam(value="group") String groupname) {
        Project project = this.getProjectByIdOrKey(projectIdOrKey);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole projectRole = this.projectRoleService.getProjectRole(id, (com.atlassian.jira.util.ErrorCollection)errorCollection);
        this.checkForErrors(errorCollection);
        if (username == null && groupname == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Set<String> userKeys = this.userkeysFromUsernames(username);
        Set<String> existingGroupnames = this.existingGroupNames(groupname);
        if (userKeys.isEmpty() && existingGroupnames.isEmpty()) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        if (!userKeys.isEmpty()) {
            SimpleErrorCollection addActorUserErrorCollection = new SimpleErrorCollection();
            this.projectRoleService.removeActorsFromProjectRole(userKeys, projectRole, project, "atlassian-user-role-actor", (com.atlassian.jira.util.ErrorCollection)addActorUserErrorCollection);
            this.checkForErrors(addActorUserErrorCollection);
        }
        if (!existingGroupnames.isEmpty()) {
            SimpleErrorCollection addActorGroupnameErrorCollection = new SimpleErrorCollection();
            this.projectRoleService.removeActorsFromProjectRole(existingGroupnames, projectRole, project, "atlassian-group-role-actor", (com.atlassian.jira.util.ErrorCollection)addActorGroupnameErrorCollection);
            this.checkForErrors(addActorGroupnameErrorCollection);
        }
        return Response.noContent().build();
    }

    private Set<String> userkeysFromUsernames(String ... usernames) {
        if (usernames != null) {
            return Arrays.stream(usernames).map(arg_0 -> ((UserManager)this.userManager).getUserByName(arg_0)).filter(Objects::nonNull).map(ApplicationUser::getKey).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Set<String> existingGroupNames(String ... groupnames) {
        if (groupnames != null) {
            return Arrays.stream(groupnames).filter(Objects::nonNull).filter(group -> this.groupManager.groupExists(group)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Project getProjectByIdOrKey(String projectIdOrKey) {
        ProjectService.GetProjectResult result = this.projectFinder.getGetProjectForActionByIdOrKey(this.authContext.getUser(), projectIdOrKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (result.getErrorCollection().hasAnyErrors()) {
            ErrorCollection errors = ErrorCollection.of(result.getErrorCollection());
            if (result.getErrorCollection().getReasons().contains(ErrorCollection.Reason.FORBIDDEN)) {
                throw new NotAuthorisedWebException(errors);
            }
            throw new NotFoundWebException(errors);
        }
        return result.getProject();
    }

    private void checkForErrors(SimpleErrorCollection errorCollection) {
        if (errorCollection.hasAnyErrors()) {
            throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
        }
    }

    public static class ActorsMap
    extends HashMap<String, String[]> {
    }
}

