/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.users;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.crowd.event.application.ApplicationDirectoryOrderUpdatedEvent;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisationFinishedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.rest.v2.issue.users.DuplicatedUsersHelper;
import com.atlassian.jira.user.util.DuplicatedUsersToDirectoriesMapping;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class CachingDuplicatedUsersHelper
implements DuplicatedUsersHelper,
InitializingBean,
DisposableBean {
    private final UserManager userManager;
    private final CachedReference<DuplicatedUsersToDirectoriesMapping> userToDirectoriesCache;
    private final EventPublisher eventPublisher;
    public static final int CACHE_EXPIRY_MINUTES = 10;

    public CachingDuplicatedUsersHelper(@ComponentImport UserManager userManager, @ComponentImport CacheManager cacheManager, @ComponentImport EventPublisher eventPublisher) {
        this.userManager = userManager;
        this.userToDirectoriesCache = cacheManager.getCachedReference(CachingDuplicatedUsersHelper.class.getName() + ".list.cache", (Supplier)new DuplicatedUserToDirectoriesLoader(), new CacheSettingsBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build());
        this.eventPublisher = eventPublisher;
    }

    @Override
    public DuplicatedUsersToDirectoriesMapping getDuplicatedUserToDirectoryMapping() {
        return (DuplicatedUsersToDirectoriesMapping)this.userToDirectoriesCache.get();
    }

    @Override
    public void flushCache() {
        this.userToDirectoriesCache.reset();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.flushCache();
    }

    @EventListener
    public void onDirectoryAdded(DirectoryCreatedEvent event) {
        this.flushCache();
    }

    @EventListener
    public void onDirectoryDeleted(DirectoryDeletedEvent event) {
        this.flushCache();
    }

    @EventListener
    public void onDirectoryUpdated(DirectoryUpdatedEvent event) {
        if (event.getOldDirectory().isActive() != event.getDirectory().isActive()) {
            this.flushCache();
        }
    }

    @EventListener
    public void onDirectorySynchronised(RemoteDirectorySynchronisationFinishedEvent event) {
        this.flushCache();
    }

    @EventListener
    public void onDirectoryReorder(ApplicationDirectoryOrderUpdatedEvent event) {
        this.flushCache();
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    private class DuplicatedUserToDirectoriesLoader
    implements Supplier<DuplicatedUsersToDirectoriesMapping> {
        private DuplicatedUserToDirectoriesLoader() {
        }

        public DuplicatedUsersToDirectoriesMapping get() {
            return CachingDuplicatedUsersHelper.this.userManager.getDuplicatedUserMapping();
        }
    }
}

