/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.version;

import com.atlassian.jira.bc.project.version.remotelink.RemoteVersionLink;
import com.atlassian.jira.bc.project.version.remotelink.RemoteVersionLinkService;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.rest.v2.entity.AbstractRemoteEntityLinkResource;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.VersionResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public class RemoteVersionLinkResource
extends AbstractRemoteEntityLinkResource<Version, RemoteVersionLink> {
    private final RemoteVersionLinkService remoteVersionLinkService;
    private final ResourceUriBuilder resourceUriBuilder;

    @Inject
    public RemoteVersionLinkResource(I18nHelper i18n, JiraAuthenticationContext jiraAuthenticationContext, RemoteVersionLinkService remoteVersionLinkService, JsonEntityPropertyManager jsonEntityPropertyManager, UriInfo contextUriInfo, ResourceUriBuilder resourceUriBuilder) {
        super(i18n, jiraAuthenticationContext, jsonEntityPropertyManager, contextUriInfo);
        this.remoteVersionLinkService = remoteVersionLinkService;
        this.resourceUriBuilder = resourceUriBuilder;
    }

    public Response getRemoteVersionLink(long versionId, String globalId) {
        RemoteVersionLinkService.RemoteVersionLinkResult result = this.remoteVersionLinkService.getRemoteVersionLinkByVersionIdAndGlobalId(this.getUser(), Long.valueOf(versionId), globalId);
        return this.toResponse(this.valid(result).getRemoteVersionLink());
    }

    public Response getRemoteVersionLinksByVersionId(long versionId) {
        RemoteVersionLinkService.RemoteVersionLinkListResult result = this.remoteVersionLinkService.getRemoteVersionLinksByVersionId(this.getUser(), Long.valueOf(versionId));
        return this.toResponse(this.valid(result).getRemoteVersionLinks());
    }

    public Response getRemoteVersionLinksByGlobalId(String globalId) {
        RemoteVersionLinkService.RemoteVersionLinkListResult result = this.remoteVersionLinkService.getRemoteVersionLinksByGlobalId(this.getUser(), globalId);
        return this.toResponse(this.valid(result).getRemoteVersionLinks());
    }

    public Response putRemoteVersionLink(long versionId, String globalId, String json) {
        RemoteVersionLinkService.PutValidationResult validation = this.remoteVersionLinkService.validatePut(this.getUser(), Long.valueOf(versionId), globalId, json);
        RemoteVersionLinkService.RemoteVersionLinkResult result = this.remoteVersionLinkService.put(this.getUser(), this.valid(validation));
        return this.toSuccessfulPostResponse(this.valid(result).getRemoteVersionLink());
    }

    public Response deleteRemoteVersionLinksByVersionId(long versionId) {
        RemoteVersionLinkService.DeleteValidationResult validation = this.remoteVersionLinkService.validateDeleteByVersionId(this.getUser(), Long.valueOf(versionId));
        this.remoteVersionLinkService.delete(this.getUser(), this.valid(validation));
        return this.toSuccessfulDeleteResponse();
    }

    public Response deleteRemoteVersionLink(long versionId, String globalId) {
        RemoteVersionLinkService.DeleteValidationResult validation = this.remoteVersionLinkService.validateDelete(this.getUser(), Long.valueOf(versionId), globalId);
        this.remoteVersionLinkService.delete(this.getUser(), this.valid(validation));
        return this.toSuccessfulDeleteResponse();
    }

    @Override
    protected URI createSelfLink(RemoteVersionLink link) {
        return this.resourceUriBuilder.getBuilder(this.contextUriInfo.getBaseUriBuilder(), VersionResource.class).path(String.valueOf(link.getEntityId())).path("remotelink").path(link.getGlobalId()).build(new Object[0]);
    }
}

