/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.version;

import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.bind.DateAdapter;
import com.atlassian.jira.rest.v2.common.SimpleLinkBean;
import com.atlassian.jira.rest.v2.entity.RemoteEntityLinkJsonBean;
import com.atlassian.jira.rest.v2.issue.Examples;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XmlRootElement(name="version")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class VersionBean {
    public static final String EXPAND_OPERATIONS = "operations";
    public static final String EXPAND_REMOTE_LINKS = "remotelinks";
    static final VersionBean DOC_EXAMPLE;
    static final VersionBean DOC_EXAMPLE_2;
    static final List<VersionBean> DOC_EXAMPLE_LIST;
    static final PageBean<VersionBean> PAGED_EXAMPLE;
    static final PageBean<VersionBean> PAGED_EXAMPLE_2;
    static final VersionBean DOC_CREATE_EXAMPLE;
    @XmlAttribute
    private String expand;
    @XmlElement
    private URI self;
    @XmlElement
    private String id;
    @XmlElement
    private String description;
    @XmlElement
    private String name;
    @XmlElement
    private Boolean archived;
    @XmlElement
    private Boolean released;
    @XmlTransient
    private Date startDate;
    @XmlTransient
    private boolean startDateSet = false;
    @XmlTransient
    private Date releaseDate;
    @XmlTransient
    private boolean releaseDateSet = false;
    @XmlElement
    private Boolean overdue;
    @XmlElement
    private String userStartDate;
    @XmlElement
    private String userReleaseDate;
    @XmlElement
    @Deprecated
    private String project;
    @XmlElement
    private Long projectId;
    @XmlElement
    private URI moveUnfixedIssuesTo;
    @XmlElement
    private ArrayList<SimpleLinkBean> operations;
    @XmlElement
    private List<RemoteEntityLinkJsonBean> remotelinks;

    public String getId() {
        return this.id;
    }

    public String getProject() {
        return this.project;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public String getUserStartDate() {
        return this.userStartDate;
    }

    public String getUserReleaseDate() {
        return this.userReleaseDate;
    }

    public Boolean getOverdue() {
        return this.overdue;
    }

    @XmlElement
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getStartDate() {
        return this.startDate;
    }

    @XmlTransient
    public boolean isStartDateSet() {
        return this.startDateSet;
    }

    @XmlElement
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getReleaseDate() {
        return this.releaseDate;
    }

    @XmlTransient
    public boolean isReleaseDateSet() {
        return this.releaseDateSet;
    }

    public Boolean isReleased() {
        return this.released;
    }

    public Boolean isArchived() {
        return this.archived;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExpand() {
        return this.expand;
    }

    public URI getSelf() {
        return this.self;
    }

    public URI getMoveUnfixedIssuesTo() {
        return this.moveUnfixedIssuesTo;
    }

    public void setSelf(URI self) {
        this.self = self;
    }

    public void setId(Long id) {
        this.id = id == null ? null : id.toString();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    public void setReleased(Boolean released) {
        this.released = released;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
        this.startDateSet = true;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
        this.releaseDateSet = true;
    }

    public void setOverdue(Boolean overdue) {
        this.overdue = overdue;
    }

    public void setUserStartDate(String userStartDate) {
        this.userStartDate = userStartDate;
    }

    public void setUserReleaseDate(String userReleaseDate) {
        this.userReleaseDate = userReleaseDate;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void setMoveUnfixedIssuesTo(URI moveUnfixedIssuesTo) {
        this.moveUnfixedIssuesTo = moveUnfixedIssuesTo;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public VersionBean() {
    }

    private VersionBean(Long id, String project, Long projectId, URI self, String name, String description, boolean archived, boolean released, Date startDate, boolean startDateSet, String userStartDate, Date releaseDate, boolean releaseDateSet, String userReleaseDate, Boolean overdue, ArrayList<SimpleLinkBean> operations, List<RemoteEntityLinkJsonBean> remotelinks, String expand) {
        this.id = id == null ? null : id.toString();
        this.self = self;
        this.description = description;
        this.name = name;
        this.archived = archived;
        this.released = released;
        this.startDate = startDate;
        this.startDateSet = startDateSet;
        this.userStartDate = userStartDate;
        this.releaseDate = releaseDate;
        this.releaseDateSet = releaseDateSet;
        this.userReleaseDate = userReleaseDate;
        this.overdue = overdue;
        this.project = project;
        this.projectId = projectId;
        this.operations = operations;
        this.remotelinks = remotelinks;
        this.expand = expand;
    }

    static {
        DOC_EXAMPLE_LIST = new ArrayList<VersionBean>();
        SimpleDateFormat exampleDateFormat = new SimpleDateFormat("d/MMM/yyyy", Locale.ENGLISH);
        VersionBean version = new Builder().build();
        version.self = Examples.restURI("version/10000");
        version.id = "10000";
        version.name = "New Version 1";
        version.description = "An excellent version";
        version.archived = false;
        version.released = true;
        version.overdue = true;
        version.releaseDate = new Date(1278385482288L);
        version.userReleaseDate = exampleDateFormat.format(version.releaseDate);
        version.projectId = 10000L;
        DOC_EXAMPLE = version;
        version = new Builder().build();
        version.self = Examples.restURI("version/10010");
        version.id = "10010";
        version.name = "Next Version";
        version.description = "Minor Bugfix version";
        version.archived = false;
        version.released = false;
        version.overdue = false;
        version.projectId = 10000L;
        DOC_EXAMPLE_2 = version;
        DOC_EXAMPLE_LIST.add(DOC_EXAMPLE);
        DOC_EXAMPLE_LIST.add(DOC_EXAMPLE_2);
        version = new Builder().build();
        version.project = "PXA";
        version.projectId = 10000L;
        version.name = "New Version 1";
        version.description = "An excellent version";
        version.archived = false;
        version.released = true;
        version.releaseDate = new Date(1278385482288L);
        version.userReleaseDate = exampleDateFormat.format(version.releaseDate);
        DOC_CREATE_EXAMPLE = version;
        PAGED_EXAMPLE = new PageBean<VersionBean>(Examples.restURI("project/PR/version?startAt=0&maxResults=2"), Examples.restURI("project/PR/version?startAt=2&maxResults=2"), 2, 0L, 7L, false, DOC_EXAMPLE_LIST);
        PAGED_EXAMPLE_2 = new PageBean<VersionBean>(Examples.restURI("version?startAt=0&maxResults=2&query=Version"), Examples.restURI("version?startAt=2&maxResults=2&query=Version"), 2, 0L, 7L, false, DOC_EXAMPLE_LIST);
    }

    public static class Builder {
        private URI self;
        private Long id;
        private String description;
        private String name;
        private boolean archived;
        private boolean released;
        private Date startDate;
        private boolean startDateSet;
        private Date releaseDate;
        private boolean releaseDateSet;
        private Boolean overdue;
        private String userStartDate;
        private String userReleaseDate;
        @Deprecated
        private String project;
        private Long projectId;
        private ArrayList<SimpleLinkBean> operations;
        private List<RemoteEntityLinkJsonBean> remotelinks;
        private String expand;

        public URI getSelf() {
            return this.self;
        }

        public Builder setSelf(URI self) {
            this.self = self;
            return this;
        }

        public Builder setVersion(Version version) {
            this.id = version.getId();
            this.name = version.getName();
            this.description = StringUtils.stripToNull((String)version.getDescription());
            this.startDate = version.getStartDate();
            this.releaseDate = version.getReleaseDate();
            this.archived = version.isArchived();
            this.released = version.isReleased();
            return this;
        }

        public Long getId() {
            return this.id;
        }

        public Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public boolean isArchived() {
            return this.archived;
        }

        public Builder setArchived(boolean archived) {
            this.archived = archived;
            return this;
        }

        public boolean isReleased() {
            return this.released;
        }

        public Builder setReleased(boolean released) {
            this.released = released;
            return this;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Builder setStartDate(Date startDate) {
            this.startDate = startDate;
            this.startDateSet = true;
            return this;
        }

        public Date getReleaseDate() {
            return this.releaseDate;
        }

        public Builder setReleaseDate(Date releaseDate) {
            this.releaseDate = releaseDate;
            this.releaseDateSet = true;
            return this;
        }

        public Boolean getOverdue() {
            return this.overdue;
        }

        public Builder setOverdue(Boolean overdue) {
            this.overdue = overdue;
            return this;
        }

        public String getUserStartDate() {
            return this.userStartDate;
        }

        public Builder setUserStartDate(String userStartDate) {
            this.userStartDate = userStartDate;
            return this;
        }

        public String getUserReleaseDate() {
            return this.userReleaseDate;
        }

        public Builder setUserReleaseDate(String userReleaseDate) {
            this.userReleaseDate = userReleaseDate;
            return this;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public ArrayList<SimpleLinkBean> getOperations() {
            return this.operations;
        }

        public Builder setOperations(ArrayList<SimpleLinkBean> operations) {
            this.operations = operations;
            return this;
        }

        public List<RemoteEntityLinkJsonBean> getRemoteLinks() {
            return this.remotelinks;
        }

        public Builder setRemoteLinks(List<RemoteEntityLinkJsonBean> remotelinks) {
            this.remotelinks = remotelinks;
            return this;
        }

        public Builder setProjectId(Long projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setExpand(String expand) {
            this.expand = expand;
            return this;
        }

        public VersionBean build() {
            return new VersionBean(this.id, this.project, this.projectId, this.self, this.name, this.description, this.archived, this.released, this.startDate, this.startDateSet, this.userStartDate, this.releaseDate, this.releaseDateSet, this.userReleaseDate, this.overdue, this.operations, this.remotelinks, this.expand);
        }
    }
}

