/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.monitoring;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.monitoring.AppMonitoringMetricsService;
import com.atlassian.jira.rest.v2.monitoring.MonitoringController;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="monitoring/app")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AppMonitoringController
extends MonitoringController {
    private final AppMonitoringMetricsService appMonitoringMetricsService;

    @Inject
    public AppMonitoringController(@Nonnull @ComponentImport GlobalPermissionManager permissionManager, @Nonnull @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @Nonnull @ComponentImport AppMonitoringMetricsService appMonitoringMetricsService) {
        super(permissionManager, jiraAuthenticationContext);
        this.appMonitoringMetricsService = Objects.requireNonNull(appMonitoringMetricsService, "appMonitoringMetricsService");
    }

    @GET
    @WebSudoRequired
    public Response isAppMonitoringEnabled() {
        return this.onlyAsAdmin(() -> Response.ok((Object)new AppMonitoringRestEntity(this.appMonitoringMetricsService.isAppMonitoringEnabled())).build());
    }

    @POST
    @WebSudoRequired
    public Response setAppMonitoringEnabled(@RequestBody AppMonitoringRestEntity appMonitoringRequest) {
        return this.onlyAsAdmin(() -> {
            this.appMonitoringMetricsService.setAppMonitoringEnabled(appMonitoringRequest.isEnabled().booleanValue());
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @VisibleForTesting
    public static class AppMonitoringRestEntity {
        private Boolean isEnabled;

        public AppMonitoringRestEntity(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public AppMonitoringRestEntity() {
        }

        public void setEnabled(Boolean enabled) {
            this.isEnabled = enabled;
        }

        public Boolean isEnabled() {
            return this.isEnabled;
        }
    }
}

